(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	A build functor for Tcp.


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	functor Build_Tcp

		1.	functor Build_Tcp

*)

functor Build_Tcp (structure Device: DEVICE_PROTOCOL
		     sharing type Device.Incoming.T = Device.Outgoing.T
		   structure B: FOX_BASIS
		   val tcp_over_ip: Word8.word
		   val initial_window_size: int
		   val user_timeout: Word32.word (* in milliseconds *)
		   val compute_checksums: bool
		   val eth_debug_level: int ref option
		   val arp_debug_level: int ref option
		   val ip_debug_level: int ref option
		   val tcp_debug_level: int ref option): TCP_STACK =
 struct

  local
   val ip_protocol = Word16.fromInt 0x800
   val icmp_protocol = Word8.fromInt 1

   structure Lower = Build_Ip (structure Device = Device
			       structure B = B
			       val ip_protocol = ip_protocol
			       val icmp_protocol = icmp_protocol
			       val log_icmp_echos = false
			       val eth_debug_level = eth_debug_level
			       val arp_debug_level = arp_debug_level
			       val ip_debug_level = ip_debug_level)
  in
   open Lower
  end

  structure Tcp = Tcp (structure Lower = Ip
		       structure B = B
		       val tcp_protocol = tcp_over_ip
		       val initial_window = initial_window_size
		       val compute_checksums = compute_checksums
		       val user_timeout = user_timeout
		       val debug_level = tcp_debug_level)

 end (* struct *)
 
