(*

        FoxNet: The Fox Project's Communication Protocol Implementation Effort
        Edo Biagioni (esb@cs.cmu.edu)
        Fox Project
        School of Computer Science
        Carnegie Mellon University
        Pittsburgh, Pa 15139-3891

	i.	Abstract

	ipmux.sig: signature for the Internet Protocol Multiplexer layer.


	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature IPMUX_ADDRESS
	2.	signature IPMUX_PATTERN
	3.	signature IPMUX_CONNECTION_KEY
	4.	signature IP_MULTIPLEXER


	1.	signature IPMUX_ADDRESS
*)

signature IPMUX_ADDRESS =
 sig
  include KEY
  type ip_number
  datatype address = Unicast of {interface: string, peer: ip_number}
                   | Broadcast of string
  sharing type T = address
 end (* sig *)

(*
	2.	signature IPMUX_PATTERN
*)

signature IPMUX_PATTERN =
 sig
  include KEY
  type ip_number
  datatype pattern = Unicast of string
                   | Broadcast of string
                   | All
  sharing type T = pattern
 end (* sig *)

(*
	3.	signature IPMUX_CONNECTION_KEY
*)

signature IPMUX_CONNECTION_KEY =
 sig
  include KEY
  val interface: T -> string
 end (* sig *)

(*
	4.	signature IP_MULTIPLEXER

	Modules satisfying this signature provide the same functions
	as those satisfying ADDRESS_RESOLUTION, but using a
	different syntax that lets us select among multiple
	lower-level interfaces.  For now we use string as the
        type of an interface identifier.
*)

signature IP_MULTIPLEXER =
 sig
  include PROTOCOL

  type ip_number

  structure Mux_Setup: NETWORK_SETUP
  structure Mux_Address: IPMUX_ADDRESS
  structure Mux_Pattern: IPMUX_PATTERN
  structure Mux_Connection_Key: IPMUX_CONNECTION_KEY

  datatype interface = Enabled of string * ip_number
                     | Disabled of string

  datatype mux_session_extension =
      Mux_Session_Extension of
        {interfaces: unit -> interface list,
	 set_interface: interface -> unit,
	 maximum_packet_size: string -> Word.word,
	 minimum_packet_size: string -> Word.word}

  sharing Address = Mux_Address
      and Pattern = Mux_Pattern
      and Setup = Mux_Setup 
      and Connection_Key = Mux_Connection_Key 
      and type ip_number = Mux_Address.ip_number = Mux_Pattern.ip_number =
               Mux_Setup.host_id
      and type session_extension = mux_session_extension
      and type listen_extension = unit 
 end
