(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract


	IP packet fragmentation and reassembly support.

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature IP_FRAGMENT



		1.	signature IP_FRAGMENT
*)

signature IP_FRAGMENT =
 sig
  type ip_header
  type incoming
  type outgoing
  type T			(* explicit state, managed by caller *)

  (* Before calling fragment, check that the packet is too
     large to send as is, and that its Do-Not-Fragment flag
     is clear.

     Fragment takes the following arguments:
       packet: the packet to be fragmented, with no header.
       header: the header to prepend to the packet.
       max_size, min_size: size of the largest and smallest
           IP packets (size includes headers) we can send.

     Fragment returns a list of packets to send, with the correct
     header prepended to each. *)

  val fragment: {packet: outgoing, header: ip_header,
		 max_size: Word.word, min_size: Word.word}
              -> (outgoing * ip_header * Word.word (* header size *) ) list

  (* Reassemble should be called whenever a packet fragment
     (indicated by the More-Fragments flag, or nonzero
     Fragment-Offset field) arrives.

     Reeassemble returns SOME <packet> following successful reassembly,
     and NONE when more fragments are needed or following an error.

     Reassemble uses some state, which must be managed by the caller.
     State is created using new, and should be garbage collected
     approximately once every second by calling gc.

     The argument to new is a function that is called if one or
     more fragments expire without being completely reassembled. *)

  type ip_packet = incoming * ip_header * incoming (* raw packet *)
  val new: ({header: ip_header, fragment: incoming,
	     raw_packet: incoming} -> unit) -> T
  val reassemble: T * ip_packet -> (ip_packet option * T)
  val gc: T -> T

 end (* sig *)

