(*

        FoxNet: The Fox Project's Communication Protocol Implementation Effort
        Edo Biagioni (esb@cs.cmu.edu)
        Fox Project
        School of Computer Science
        Carnegie Mellon University
        Pittsburgh, Pa 15139-3891

		i.	Abstract

	ip.sig: signature for protocols in the TCP/IP stack


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature ICMP_PROTOCOL
	2.	signature IP_PROTOCOL
	3.	IP Options
	4.	ICMP
	5.	extensions


	1.	signature ICMP_PROTOCOL
*)

signature ICMP_PROTOCOL =
 sig
  include PROTOCOL

  type ip_number
  sharing type Address.T = Connection_Key.T = ip_number

  type data_in
  type data_out
  type id
  type seq
  type timestamp (* needed for the NJ concrete/abstract bug: *) = Word32.word
  datatype icmp_in =
      Echo_Reply of {id: id, sequence: seq, data: data_in}
    | Timestamp_Reply of {id: id, sequence: seq, originate: timestamp,
			  receive: timestamp, transmit: timestamp,
			  returned: timestamp}
    | Traceroute of {forwarded: bool, id: Word16.word,
		     out_hops: Word16.word, return_hops: Word16.word,
		     out_speed: Word32.word, out_mtu: Word32.word}

  datatype icmp_out =
      Echo_Request of {id: id, sequence: seq, data: data_out}
    | Timestamp_Request of {id: id, sequence: seq}
    | Source_Quench of data_in
    | Parameter_Problem of data_in * int
    | Missing_Required_Option of data_in

  sharing type Incoming.T = icmp_in
      and type Outgoing.T = icmp_out
 end

(*
	2.	signature IP_PROTOCOL
*)

signature IP_PROTOCOL =
 sig

  include NETWORK_PROTOCOL

(*
	3.	IP Options
*)

  structure Option: IP_OPTION
  sharing type Option.ip_number = Host_Id.T
      and type Option.ip_option = Network_Outgoing.net_option
	     = Network_Incoming.net_option

(*
	4.	ICMP
*)

  structure Icmp: ICMP_PROTOCOL
  sharing type Icmp.ip_number = Host_Id.T
      and type Icmp.data_in = Incoming.T
      and type Icmp.data_out = Outgoing.T = Network_Outgoing.T
      and type Icmp.id = Word16.word
      and type Icmp.seq = Word16.word
      and type Icmp.timestamp = Word32.word
      and type Icmp.Setup.T = Network_Setup.T
      and type Icmp.Address.T = Host_Id.T
      and type Icmp.connection_extension = network_connection_extension
      and type Icmp.Status.T = Network_Status.T

(*
	5.	extensions
*)

  type ip_session_extension = unit

  sharing type specific_session_extension = ip_session_extension 
      and type listen_extension = unit 
      and type specific_connection_extension = unit 

 end (* sig *)

