(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract
	
       A functor to build ip on top of eth on top of ethdev.


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	BuildIp


		1.	BuildIp
*)

functor Build_Ip (structure Device: DEVICE_PROTOCOL
		  structure B: FOX_BASIS
		  sharing type Device.Outgoing.T = Device.Incoming.T
		  val icmp_protocol: Word8.word
		  val ip_protocol: Word16.word
		  val eth_debug_level: int ref option
		  val arp_debug_level: int ref option
		  val ip_debug_level: int ref option): IP_STACK =
 struct

  val arp_protocol_number = Word16.fromInt 0x806

  structure Device = Device

  structure Eth = Ethernet (structure Device = Device
			    structure B = B
			    val debug_level = eth_debug_level)

  structure Arp = Arp_Eth (structure Eth = Eth
			   val arp_protocol_number = arp_protocol_number
			   structure B = B
			   val debug_level = arp_debug_level)

  structure Loop = Ip_Loop (structure Setup = Arp.Setup
			    structure Count = Arp.Count
			    structure External = Arp.Incoming
			    structure X = Arp.X
			    structure B = B
			    val debug_level = arp_debug_level)

  val loopback = "lo0"
  fun is_loopback interface = B.V.String.caseless_equal (interface, loopback)
  val not_loopback = not o is_loopback

  structure Ip_Mux = Ip_Mux2 (structure Arp1 = Arp
			      structure Arp2 = Loop
			      val is_interface1 = not_loopback
			      val is_interface2 = is_loopback
			      val ip_protocol_number1 = Word16.fromInt 0x800
			      val ip_protocol_number2 = Word16.fromInt 0
			      structure B = B
			      val debug_level = ip_debug_level)
(*
  structure Ip_Mux = Ip_Mux1 (structure Arp = Arp
			      structure Arp_Setup = Device.Setup
			      structure B = B
			      val ip_protocol_number = ip_protocol)
*)

  structure Ip = Ip (structure Lower = Ip_Mux
		     structure Host_Id = Ip_Host_Id
		     structure B = B
		     val icmp_protocol = icmp_protocol
		     val gateway = false
		     val debug_level = ip_debug_level)

 end
