(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Kuo Chiang Chiang (kcchiang@cs.cmu.edu)
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

	i.	Abstract
		
	This functor marshals and unmarshals Ethernet headers.

	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	functor Eth_Header


	1.	functor Eth_Header
*)

functor Eth_Header (structure In: EXTERNAL
		    structure Out: EXTERNAL
		    structure B: FOX_BASIS): EXTERN =
 struct
  type T = {self: Word48.word, peer: Word48.word, proto: Word16.word}
  type extern_in = In.T
  type extern_out = Out.T
  type cursor = Word.word
  exception Extern

  val fixed_size = 0w14
  fun size _ = fixed_size

  structure Word48 = 
      Protocol_Extern48_Big (structure In = In
			     structure Out = Out
			     structure B = B)
  structure Word16 = 
      Protocol_Extern16_Big (structure In = In
			     structure Out = Out
			     structure B = B)

  fun marshal (array, {self, peer, proto}) =
       (Word16.marshal (array, proto) o
        Word48.marshal (array, self) o
        Word48.marshal (array, peer))

  fun unmarshal (array, cursor) =
       (let val (self, p_cursor) = Word48.unmarshal (array, cursor)
            val (peer, proto_cursor) = Word48.unmarshal (array, p_cursor)
            val (proto, last) = Word16.unmarshal (array, proto_cursor)
        in ({self = self, peer = peer, proto = proto}, last)
        end)
	 handle _ => raise Extern

 end (* struct *)
