(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Edoardo Biagioni <Edoardo.Biagioni@cs.cmu.edu>
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	This is a signature for a protocol that is a low level driver, e.g.,
 talks bytes with a device.


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature RAW_DEVICE
	2.	signature DEVICE_PROTOCOL


		1.	signature RAW_DEVICE
*)

signature RAW_DEVICE =
 sig
  structure External: EXTERNAL

  structure Setup: KEY
    sharing type Setup.T = string

  type session =
        {send: External.T -> unit,
         local_address: Word_Array.T,
         packets_sent: unit -> Word64.word,
         packets_received: unit -> Word64.word,
         read_timeouts: unit -> Word64.word,
         failed_sends: unit -> Word64.word,
         packets_rejected: unit -> Word64.word}

  exception Session_Already_Open

  val session: (Setup.T * (session -> ((unit -> 'a) * (External.T -> unit))))
               -> 'a

 end

(*
		2.	signature DEVICE_PROTOCOL
*)

signature DEVICE_PROTOCOL =
 sig
  include PROTOCOL

  datatype dev_session_extension =
      Dev_Session_Extension of
        {local_address: Word_Array.T,
         packets_sent: unit -> Word64.word,
         packets_received: unit -> Word64.word,
         read_timeouts: unit -> Word64.word,
         failed_sends: unit -> Word64.word,
         packets_rejected: unit -> Word64.word}

  sharing type Address.T = Pattern.T = unit
      and type session_extension = dev_session_extension
      and type Setup.T = string
 end
