(*

        FoxNet: The Fox Project's Communication Protocol Implementation Effort
        Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
        Brian Milnes (Brian.Milnes@cs.cmu.edu)
        Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Robert Findler (Robert.Findler@cs.cmu.edu)
        Fox Project
        School of Computer Science
        Carnegie Mellon University
        Pittsburgh, Pa 15139-3891

                i.      Abstract

	This was created by Peter Lee and Edo Biagioni

                ii.     Table of Contents

        i.      Abstract
        ii.     Table of Contents
        1.      


                1.      signature EXTERN

	A structure with signature EXTERN provides operations to
	marshall and unmarshall values of one specific type.  Marshall
	means that the value is encoded into a mutable value of type
	extern; unmarshall that the value is taken from the value of
	type extern.  It is assumed that an extern may store multiple
	values of different types, and that a cursor is used to keep
	track of the final position of the last marshalling or
	unmarshalling.

	Marshall may fail if insufficient space is available;
	unmarshalling, likewise, and also if the value in the extern
	is not a valid encoding for a value of type T.  In all of
	these cases, the exception Extern is raised.
*) 

signature EXTERN =
 sig
  type T
  type extern_in
  type extern_out
  type cursor

  exception Extern

  (* Size returns the size required to marshall the given value. *)
  val size: T -> Word.word
  val marshal: extern_out * T -> cursor -> cursor
  val unmarshal: extern_in * cursor -> T * cursor
 end (* sig *)
