(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Edoardo Biagioni <Edoardo.Biagioni@cs.cmu.edu>
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	pipe.sig: signature for synchronized data pipes

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature DATA_PIPE


		1.	signature DATA_PIPE

 A data pipe stores enqueued values until dequeued in first-in, first-out
 order. A dequeue operation on a pipe with no data will block, and is
 only restarted after another thread queues some data. If more than one
 dequeue operation is blocked, they are satisfied in FIFO order.

 *)

signature DATA_PIPE =
 sig
  type 'value T

(* To discard excess data, use the size function.  To dequeue from
   any one of a set of pipes, use "dequeue o select". (select will
   block forever if given an empty list). *)

  val new: unit -> '1value T

  val enqueue: '1value T * '1value -> unit
  val dequeue: '1value T -> '1value

  val select: '1value T list -> '1value
  val dequeue_immediately: '1value T -> '1value option
  val dequeue_timeout: '1value T * int -> '1value option

(* a data item re-queue will be placed in the front of the queue,
   not the back. This violates the normal FIFO ordering of the queue,
   but can be very useful in selected cases. The caller may be suspended
   if the queue is overfull. *)
  val requeue: '1value T * '1value -> unit

(* the size of a pipe with "dequeue" operations pending is negative. *)
  val size: '1value T -> int
  val clear: '1value T -> unit

 end
