(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Edoardo Biagioni <Edoardo.Biagioni@cs.cmu.edu>
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	coro.sig: signature COROUTINE, for a simple coroutine package


		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature COROUTINE

		1.	signature COROUTINE

*)

signature COROUTINE =
 sig

(* This exception is raised by exit when no other process can be woken up. *)
  exception No_Ready_Thread

(* Eliminate all but the calling thread. *)
  val reset: unit -> unit

(* fork creates a coroutine, queues it, and returns to the parent process.
   fork_limited_time coroutines are given the time they are allowed to
   execute for (in ms) when they are called;  in return, they are
   given higher priority than regular coroutines.
 *)
  val fork: (unit -> unit) -> unit

  val fork_limited_time: (int -> unit) -> unit

(* Sleep suspends this thread for at least the specified
   number of milliseconds. If there are any coroutines on the
   ready queue, execution of the first ready coroutine begins
   immediately. *)
  val sleep: int -> unit

  exception No_Such_Suspension

(* suspend suspends this thread until a corresponding resume, returning
   the value provided by resume.
   The suspended thread's suspension is given to the argument function.
   When resuming a function, the resumed coroutine is placed on
   the ready queue and the calling coroutine continues execution.
   A suspension can only be resumed once; attempts to resume it
   more than once raise No_Such_Suspension.
 *)
  type '1a suspension
  val suspend: ('1a suspension -> 'b) -> '1a
  val resume: 'a suspension * 'a -> unit

(* Exit terminates the current thread and restarts a ready thread, if any;
   raises No_Ready_Thread if there are no more ready or sleeping threads. *)
  val exit: unit -> 'a

 end

