(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Edoardo Biagioni <Edoardo.Biagioni@cs.cmu.edu>
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	A signature to interface to the SML vendor's added functionality.

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature VENDOR_CHAR
	2.	signature VENDOR_STRING
	3.	signature VENDOR_LIST
	4.	signature VENDOR_ARRAY
	5.	signature VENDOR_CONTROL
	6.	signature VENDOR_PRINT
	7.	signature VENDOR_TIME
	8.	signature VENDOR_MISC
	9.	signature VENDOR_IO

	
		1.	signature VENDOR_CHAR
*)

signature VENDOR_CHAR =
  sig
    eqtype char
    exception Chr
    val chr: int -> char
    val ord: char -> int
    val maxOrd: int
    val to_lower: char -> char
    val to_upper: char -> char
    val < : char * char -> bool
    val <= : char * char -> bool
    val > : char * char -> bool
    val >= : char * char -> bool
    val caseless_equal: char * char -> bool
    val caseless_less: char * char -> bool
    val caseless_greater: char * char -> bool
    val isSpace: char -> bool
  end

(*
		2.	signature VENDOR_STRING
*)

signature VENDOR_STRING =
  sig
    eqtype string
    val length: string -> int
    val ordof: string * int -> char
    val substring: string * int * int -> string
    val concat: string list -> string
    val ^ : string * string -> string
    val str: char -> string
    val implode: char list -> string
    val explode: string -> char list

    val to_lower: string -> string
    val to_upper: string -> string
    val caseless_equal: string * string -> bool

    val index: string * string * int -> int option
    val tokens : (char -> bool) -> string -> string list
    val fields : (char -> bool) -> string -> string list
    exception Bad_Integer_String of string
    val string_to_int: string -> int

    val <  : string * string -> bool
    val <= : string * string -> bool
    val >  : string * string -> bool
    val >= : string * string -> bool
  end

(*
		3.	signature VENDOR_LIST
*)

signature VENDOR_LIST = 
 sig
  val fold: ('a * 'b -> 'b) -> 'a list -> 'b -> 'b
  val revfold: ('a * 'b -> 'b) -> 'a list -> 'b -> 'b
  val length: 'a list -> int
  val reverse: 'a list -> 'a list
  val map: ('a -> 'b) -> 'a list -> 'b list
  val app: ('a -> unit) -> 'a list -> unit
  val revapp: ('a -> unit) -> 'a list -> unit
  val nth: 'a list * int -> 'a
  val member: ''a list -> ''a -> bool
 end (* sig *)

(*
		4.	signature VENDOR_ARRAY
*)

signature VENDOR_ARRAY =
 sig
  type 'a array
  val tabulate: int * (int -> '1a) -> '1a array
  val sub: 'a array * int -> 'a
  val length: 'a array -> int
  val update: 'a array * int * 'a -> unit
 end (* sig *)

(*
		5.	signature VENDOR_CONTROL
*)

signature VENDOR_CONTROL =
 sig
  type 'a cont
  val callcc: ('1a cont -> '1a) -> '1a
  val throw: 'a cont -> 'a -> 'b
  val exnName: exn -> string
 end (* sig *)

(*
		6.	signature VENDOR_PRINT
*)

signature VENDOR_PRINT =
 sig
  val print: string -> unit
  val flush: unit -> unit 
  val print_byte1f3: Word8.word -> unit
  val print_byte1Uarray: Word8Array.array -> unit
 end (* sig *)

(*
		7.	signature VENDOR_TIME
*)

signature VENDOR_TIME =
 sig
  type time
  val now: unit -> time
  val toSeconds: time -> int		(* range 0...oo *)
  val fromSeconds: int -> time
  val toMilliseconds: time -> int	(* range 0...999 *)
  val fromMilliseconds: int -> time
  val toMicroseconds: time -> int	(* range 0...999,999 *)
  val fromMicroseconds: int -> time

  val split: time -> {years: int,
		      months: int,
		      days: int,
		      weekdays: int,
		      hours : int,
		      minutes: int,
		      seconds: int,
		      microseconds: int}

  val - : time * time -> time
  val + : time * time -> time

  val addms: time * int -> time
  val deltams: time * time -> int

  val < : time * time -> bool
  val > : time * time -> bool
  val = : time * time -> bool

  val toString: time -> string
  val toDate: time -> string

  val zeroTime : time
 end (* sig *)

(*
		8.	signature VENDOR_MISC
*)

signature VENDOR_MISC =
 sig
  exception Bad_Size
  val create_uninitialized: int -> Word8Array.array (* may raise Bad_Size *)
  val environment: unit -> string list
 end (* sig *)


(*
		9.	signature VENDOR_IO
*)

signature VENDOR_IO =
 sig
   type instream
   type outstream
   val std_in : instream
   val std_out : outstream
   val std_err : outstream
   val open_in : string -> instream
   val open_out : string -> outstream
   val open_append : string -> outstream
   val close_in : instream -> unit
   val close_out : outstream -> unit
   val output : outstream * string -> unit
   val outputc : outstream -> string -> unit
   val input : instream * int -> string
   val inputc : instream -> int -> string
   val input_line : instream -> string
   val lookahead : instream -> string
   val end_of_stream : instream -> bool
   val flush_out : outstream -> unit
 end (* sig *)

(*
                8.      signature VENDOR
*)

signature VENDOR =
 sig
  structure Char: VENDOR_CHAR
  structure String: VENDOR_STRING
  structure List: VENDOR_LIST
  structure Array: VENDOR_ARRAY
  structure Control: VENDOR_CONTROL
  structure Print: VENDOR_PRINT
  structure Time: VENDOR_TIME
  structure Misc: VENDOR_MISC
  structure IO: VENDOR_IO
  val operating_system: string
  sharing type String.string=string
    and type Char.char=char
 end (* sig *)

