(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Ken Cline (Ken.Cline@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	A priority queue.

	i.	Abstract
	ii.	Table of Contents
	1.	signature PRIORITY_QUEUE


	1.	signature PRIORITY_QUEUE
*)

signature PRIORITY_QUEUE =
 sig
  type key
  type T        (* The type of the priority queue. *)

  val new: unit -> T 
  val size: T -> int		(* The number of objects in the queue. *)
  val empty: T -> bool		(* Is this priority queue empty ? *)

  (* Add an element to the priority queue via a side effect. *)
  (* Return a function to delete that element.               *)
  (* If the delete function is called more than once, or after the element   *)
  (* has been removed via next or pop, the Not_In_Queue exception is raised. *)
  val add: T * key -> (unit -> unit)
  exception Not_In_Queue

  (* Return the minimum item in the priority queue. *)
  val first: T -> key option  

  (* Return the minimum item in the priority queue.  Delete this item *)
  (* from the priority queue via a side effect.                       *)
  val next: T -> key option

  (* Delete the minimum item in the priority queue with a side effect. *)
  val pop: T -> unit

  (* Physically remove all deleted elements. *)
  val cleanup : T -> unit

  val fold: (key * 'b -> 'b) -> T -> 'b -> 'b

  val makestring: T * (key -> string) * string (* separator *) -> string

 end (* sig *)
