(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni <Edoardo.Biagioni@cs.cmu.edu>
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

	i.	Abstract
	fifo.sig: signature FIFO. A fifo is used to store objects
	and retrieve them in the same order in which they were
	stored (First-In-First-Out).

	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature FIFO


		1.	signature FIFO
*)

signature FIFO =
 sig
  type 'a T		(* the type of the fifo itself *)

  val new: unit -> 'a T	(* create a new, empty fifo *)
  val size: 'a T -> int
  val empty: 'a T -> bool

  (* add an element at the end of the fifo *)
  val add: 'a T * 'a -> 'a T

  val next: 'a T -> ('a T * 'a) option

  (* delete only returns a new FIFO if something was deleted. *)
  val delete: 'a T * ('a -> bool) -> 'a T option

  val map: ('a -> 'b) -> 'a T -> 'b T

  val fold: ('a * 'b -> 'b) -> 'a T -> 'b -> 'b

  val makestring: 'a T * ('a -> string) * string (* separator *) -> string

 end
