(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (esb@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	A one's complment 16 bit signed checksum module (as specified
	for TCP/IP/UDP). 

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	CHECKSUM


		1.	CHECKSUM
*)

signature CHECKSUM =
 sig

  (* Checksum_Bounds may be raised if the bounds are improper.
     Other exceptions could also be raised. *)
  exception Checksum_Bounds

  val one_s_add: Word16.word * Word16.word -> Word16.word

  val one_s_complement: Word16.word -> Word16.word

  (* checksum computes the checksum of the given array.
     The returned checksum is in machine byte order *)
  val checksum: Word_Array.T -> Word16.word

  (* A partial computation can be done in stages, one stage for
     each word_array that is part of the whole.  The computation
     MUST be done front-to-back and using the given partial states. *)
  type partial_state
  val initial_state: partial_state
  val check_partial: Word_Array.T * partial_state -> partial_state
  val complete_partial: partial_state -> Word16.word

 end
