(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edo Biagioni (esb@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

	i.	Abstract

	tcpstate.sig: this is the signature for the TCP finite state machine.


	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature TCP_STATE


	1.	signature TCP_STATE
*)

signature TCP_STATE =
 sig

  type tcp_state
  type tcp_timer

(* These calls return an updated state, often with a non-empty to_do list *)
  val active_open: tcp_state
                 * int (* initial window *)
                 * int (* maximum segment size *)
                 -> tcp_state
  val passive_open: tcp_state
                  * int (* initial window *)
                  * int (* maximum segment size *)
                  -> tcp_state
  val close: tcp_state -> tcp_state
  val abort: tcp_state -> tcp_state
  val timeout: tcp_state * tcp_timer -> tcp_state

 end (* sig *)

