(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edo Biagioni (esb@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

	i.	Abstract

	tcpsend.sig: this is the signature for the TCP send operation.


	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature TCP_SEND



	1.	signature TCP_SEND
*)

signature TCP_SEND =
 sig

  type tcp_state
  type tcp_out
  type send_packet
  type segment

  datatype send_state = Valid_Send | Opening_Send | Closing_Send

  val send_state: tcp_state -> send_state

  (* Send takes the latest TCP state and returns an updated state
     after having sent as many queued packets as possible, or a
     window probe if it is not possible to send any packets. *)
  val send: tcp_state -> tcp_state

  exception Send_Packet of string

  (* send_packet take the state, urgent flag, packet, and a function
     which adds a header and enqueues the packet for sending.
     It then calls send to do the actual sending. *)
  val send_packet:
        tcp_state * send_packet * bool * (tcp_out -> unit) ->
	  tcp_state

 end (* sig *)

