(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (esb@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

	i.	Abstract

	Care and feeding of tcp's retransmit queue.


	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature TCP_RETRANSMIT


	1.	signature TCP_RETRANSMIT
*)

signature TCP_RETRANSMIT =
 sig
  structure Tcb: TCP_TCB

  (* we define as an invariant that there is an outstanding
     retransmit timer (either in the to_do list, or in the timer
     module) exactly when the resend queue is non-empty.
     This invariant must be preserved (a) whenever the retransmit
     timer expires, (b) whenever a segment is added to the empty
     resend queue, and (c) whenever the last segment is removed
     from the resend queue. *)

  val retransmit: Tcb.tcp_tcb * Tcb.tcp_out * Tcb.time_ms
                -> Tcb.tcp_tcb

  val acknowledge: Tcb.tcp_state * Tcb.tcp_tcb * Word32.word
                 * Tcb.time_ms option (* send time, if known *)
                 -> Tcb.tcp_tcb

 end (* sig *)




