(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edo Biagioni (esb@cs.cmu.edu)
	Ken Cline (ken.cline@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

	i.	Abstract

	tcpheader.sig: executing the actions specified by
	the TCP state machine. The actions must be those
	defined in tcptcb.sig.


	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature TCP_HEADER


	1.	signature TCP_HEADER
*)

signature TCP_HEADER =
 sig

  type segment				(* data accepted from TCP *)
  type send_packet			(* data sent on lower layer *)
  type receive_packet			(* data received from lower layer *)
  type to_do_list
  datatype address = Address of {local_port: Word16.word,
				 remote_port: Word16.word}

  type action_state

  (* new creates an action_state given a packet send function
     and a packet receive function and an "act" function.

     When data comes in or a timer expires, the appropriate action
     will be queued on the to_do list. When a timer expires, the
   *)

  val new: {act: unit -> unit, to_do: to_do_list, address: address,
	    peer_checksum: send_packet -> Word16.word}
         -> action_state

  (* send_segment accepts an uninitialized segment to be sent
     and sends it, possibly adding actions to the to_do list. *)
  val send_segment: action_state * segment * (send_packet -> unit) -> unit

  (* process_packet accepts a raw packet from the network and computes
     the actions that it causes.  These actions are added to the
     to_do_list. *)
  val process_packet: action_state * receive_packet -> unit

  val identify: receive_packet -> {src:Word16.word, dest:Word16.word}

 end (* sig *)

