(*

        FoxNet: The Fox Project's Communication Protocol Implementation Effort
        Edo Biagioni (esb@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Brian Milnes (milnes@cs.cmu.edu)
        Nick Haines (nickh@cs.cmu.edu)
        Fox Project
        School of Computer Science
        Carnegie Mellon University
        Pittsburgh, Pa 15139-3891

		i.	Abstract

	transport.sig: signature for transport protocols in the TCP/IP stack

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature TRANSPORT_HOST_ID
	2.	signature TRANSPORT_SETUP
	3.	signature TRANSPORT_ADDRESS
	4.	signature TRANSPORT_PATTERN
	5.	signature TRANSPORT_CONNECTION_KEY
	6.	signature TRANSPORT_PROTOCOL
		signature TRANSPORT_PROTOCOL

	1.	signature TRANSPORT_HOST_ID
*)

signature TRANSPORT_HOST_ID = NETWORK_HOST_ID

(*
	2.	signature TRANSPORT_SETUP
*)

signature TRANSPORT_SETUP = NETWORK_SETUP

(*
	3.	signature TRANSPORT_ADDRESS

	a program using a transport protocol can specify connections
	in different ways:
	- by completely specifying the connection
	- by leaving the local port unspecified (used with connect).
	  In this case, the implementation selects a free local port.
*)

signature TRANSPORT_ADDRESS =
 sig
  include KEY
  type host_id
  type port
  datatype address = 
	Complete of {peer: host_id, local_port: port, remote_port: port}
      | Remote_Specified of {peer: host_id, remote_port: port}
  sharing type T = address
 end (* sig *)

(*
	4.	signature TRANSPORT_PATTERN

	a program using a transport protocol can listen for:
	- a completely specified connection
	- by leaving the local port unspecified (used with connect).
	  In this case, the implementation selects a free local port.
	- by leaving the peer and remote port unspecified 
	  In this case, the missing components are taken from the
	  connections that are initiated by the peer.
	- by leaving everything unspecified 
	  In this case, the transport protocol must select a
	  local port.  There are no guarantees about this port
	  being "available".
*)

signature TRANSPORT_PATTERN =
 sig
  include KEY
  type host_id
  type port
  datatype pattern = 
	Complete of {peer: host_id, local_port: port, remote_port: port}
      | Remote_Specified of {peer: host_id, remote_port: port}
      | Local_Specified of {local_port: port}
      | Unspecified
  sharing type T = pattern
 end (* sig *)

(*
	5.	signature TRANSPORT_CONNECTION_KEY
*)

signature TRANSPORT_CONNECTION_KEY =
 sig
  include KEY
  type host_id
  type port
  datatype key = Key of {peer: host_id, local_port: port, remote_port: port}
  sharing type T = key
 end (* sig *)

(*
	6.	signature TRANSPORT_PROTOCOL

	A TCP protocol uses lower-layer addresses together with local
	and remote port numbers as TCP addresses.  It is also possible
	to leave the local port unspecified if the remote port and
	peer are specified.


*)

signature TRANSPORT_PROTOCOL =
 sig

  include PROTOCOL

  structure Host_Id: TRANSPORT_HOST_ID

  type host_id
  type port
  
  structure Transport_Setup: TRANSPORT_SETUP
  structure Transport_Address: TRANSPORT_ADDRESS
  structure Transport_Pattern: TRANSPORT_PATTERN
  structure Transport_Key: TRANSPORT_CONNECTION_KEY
   sharing type host_id = Transport_Setup.host_id
              = Transport_Address.host_id = Transport_Pattern.host_id
              = Transport_Key.host_id = Host_Id.T
   sharing type port = Transport_Address.port = Transport_Pattern.port
              = Transport_Key.port = Word16.word

  type additional_listen_extension
  datatype transport_listen_extension =
        Listen_Extension of {local_port: port,
			     additional: additional_listen_extension}

  sharing type Setup.T = Transport_Setup.T
      and type Address.T = Transport_Address.T
      and type Connection_Key.T = Transport_Key.T
      and type Pattern.T = Transport_Pattern.T
      and type listen_extension = transport_listen_extension

 end (* sig *)
