(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	iproute.sig: interface to a stateless module for IP routing.

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature IP_ROUTE

		1.	signature IP_ROUTE

	Note that gateways MUST be on attached networks (RFC 1122, p. 48)
*)

signature IP_ROUTE =
 sig

  type ip_number
  type preference
  type interface
  type T			(* explicit state, managed by caller *)

  val makestring: T -> string

  exception Unknown_Class of ip_number

  val new: {interface: string, address: ip_number,
	    gateways: ip_number list, mask: ip_number option} list -> T

  val interface_for_address: T * ip_number -> string option
  val address_for_interface: T * string -> ip_number option

  val set_interface_address: T * string * ip_number -> T
  val disable_interface: T * string -> T
  val set_interface_mask: T * string * ip_number -> T
  val unset_interface_mask: T * string -> T


  exception Gateway_Not_Connected of ip_number
  val add_default_gateway: T * ip_number -> T
  val remove_default_gateway: T * ip_number -> T
  val has_default_gateway: T * string -> bool
  val add_preference_gateway: T * ip_number * preference * int (* ttl *) -> T
  val add_specific_gateway:
        T * {destination: ip_number, gateway: ip_number} -> T
  val remove_specific_gateway: T * {destination: ip_number} -> T

  datatype resolution = Unicast of {next_hop: ip_number}
                      | Broadcast
                      | Loopback

  val resolve: T * ip_number -> {interface: interface,
				 interface_ip: ip_number,
				 next_hop: resolution} option

  val valid_incoming: T * interface * ip_number -> bool

  val is_unicast_address: T * ip_number -> bool

  val gc: T -> T			(* call once a second *)

 end (* sig *)
