(*

        FoxNet: The Fox Project's Communication Protocol Implementation Effort
        Edo Biagioni (esb@cs.cmu.edu)
        Nick Haines (nickh@cs.cmu.edu)
        Brian Milnes (milnes@cs.cmu.edu)
        Fox Project
        School of Computer Science
        Carnegie Mellon University
        Pittsburgh, Pa 15139-3891


		i.	Abstract

	eth.sig: signature for ethernet protocols

		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature ETH_NUMBER
	2.	signature ETH_ADDRESS
	3.	signature ETH_PATTERN
	4.	signature ETHERNET_PROTOCOL


	1.	signature ETH_NUMBER
*)

signature ETH_NUMBER =
 sig
  include KEY
  val new: Word48.word -> T
  val convert: T -> Word48.word
 end (* sig *)

(*
	2.	signature ETH_ADDRESS
*)

signature ETH_ADDRESS =
 sig
  include KEY
  type eth_number
  type eth_protocol
  datatype address = Address of {eth: eth_number, proto: eth_protocol}
  sharing type T = address
 end (* sig *)

(*
	3.	signature ETH_PATTERN
*)

signature ETH_PATTERN =
 sig
  include KEY
  type eth_number
  type eth_protocol
  datatype pattern = Complete of {eth: eth_number, proto: eth_protocol}
                   | Partial of {proto: eth_protocol}
  sharing type T = pattern
 end (* sig *)

(*
	4.	signature ETHERNET_PROTOCOL
*)

signature ETHERNET_PROTOCOL =
 sig
  include PROTOCOL

  structure Eth_Number: ETH_NUMBER
  structure Eth_Protocol: KEY

  structure Eth_Address: ETH_ADDRESS
  structure Eth_Pattern: ETH_PATTERN
   sharing type Eth_Number.T = Eth_Address.eth_number
              = Eth_Pattern.eth_number = Word48.word
       and type Eth_Protocol.T = Eth_Address.eth_protocol
	      = Eth_Pattern.eth_protocol = Word16.word

  datatype eth_connection_extension =
      Eth_Connection_Extension of {connection_address: Address.T}

  datatype eth_session_extension =
      Eth_Session_Extension of
        {local_address: Eth_Number.T,
	 packets_sent: unit -> Word64.word,
	 packets_received: unit -> Word64.word,
	 failed_sends: unit -> Word64.word,
	 packets_rejected: unit -> Word64.word,
	 minimum_packet_size: Word.word,
	 maximum_packet_size: Word.word}

  sharing Address = Eth_Address = Connection_Key
      and Pattern = Eth_Pattern
      and type Setup.T = string
      and type Status.T = listen_extension = unit
      and type session_extension = eth_session_extension
      and type connection_extension = eth_connection_extension

 end (* sig *)

