(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (esb@cs.cmu.edu)
	Ken Cline    (Ken.Cline@cs.cmu.edu)
	Nick Haines  (Nick.Haines@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	packetfilter.sig: an interface to the OSF1 packetfilter pseudo-device.



		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature PACKET_FILTER


	1.	signature PACKET_FILTER
*)

signature PACKET_FILTER =
sig
  type T
  type filter

  val pfopen:			string -> T	(* interface name *)
  val close:			T -> unit
  val get_ethernet_address:	T -> Word_Array.T
  val set_filter:		T * filter -> unit
  val readi:			T * Word_Array.T * int * int -> int
(* select for read with int millisecond timeout *)
(* Returns false if it times out, true if the file descriptor is ready. *)
  val select:			T * int -> bool
  val write:			T * Word_Array.T * int -> unit
  val writev: T * Word_Array.T list -> int
  exception Packet_Filter
end
