(*

        FoxNet: The Fox Project's Communication Protocol Implementation Effort
        Edo Biagioni (esb@cs.cmu.edu)
        Fox Project
        School of Computer Science
        Carnegie Mellon University
        Pittsburgh, Pa 15139-3891

	i.	Abstract

	arp.sig: signature for the Address Resolution Protocol


	ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents
	1.	signature ARP_ADDRESS
	2.	signature ARP_PATTERN
	3.	signature ADDRESS_RESOLUTION_PROTOCOL


	1.	signature ARP_ADDRESS
*)

signature ARP_ADDRESS =
 sig
  type host
  type protocol
  datatype address = Specific of {self: host, peer: host, protocol: protocol}
                   | Broadcast of protocol
  include KEY
   sharing type T = address
 end (* sig *)

(*
	2.	signature ARP_PATTERN

	An Arp_pattern always specifies that broadcast packets
	will be accepted.
*)

signature ARP_PATTERN =
 sig
  type host
  type protocol
  datatype pattern = Specific of {self: host, protocol: protocol}
                   | Broadcast of protocol
  include KEY
   sharing type T = pattern
 end (* sig *)

(*
	3.	signature ADDRESS_RESOLUTION_PROTOCOL

	An address_resolution module lets a higher-level module use
	protocol addresses that may be different from lower-level
	hardware addresses.  The higher-level module never needs to
	see the lower-level addresses; we use byte arrays to store
	higher-level addresses.
*)

signature ADDRESS_RESOLUTION_PROTOCOL =
 sig

  structure Host: KEY
  structure Protocol: KEY
  structure Arp_Address: ARP_ADDRESS
  structure Arp_Pattern: ARP_PATTERN
   sharing type Host.T = Arp_Address.host = Arp_Pattern.host
       and type Protocol.T = Arp_Address.protocol = Arp_Pattern.protocol

  type arp_session_extension = {maximum_packet_size: Word.word,
				minimum_packet_size: Word.word}

  include PROTOCOL
   sharing Arp_Address = Address
       and Arp_Pattern = Pattern
       and type session_extension = arp_session_extension
       and type listen_extension = unit

 end
