(*

	FoxNet: The Fox Project's Communication Protocol Implementation Effort
	Edoardo Biagioni (Edoardo.Biagioni@cs.cmu.edu)
	Brian Milnes (Brian.Milnes@cs.cmu.edu)
	Ken Cline (Kenneth.Cline@cs.cmu.edu)
        Nick Haines (Nick.Haines@cs.cmu.edu)
	Fox Project
	School of Computer Science
	Carnegie Mellon University
	Pittsburgh, Pa 15139-3891

		i.	Abstract

	The signature of a ping operation, similar to typical unix pings.



		ii.	Table of Contents

	i.	Abstract
	ii.	Table of Contents

		1.     signature PING
*)

signature PING =
 sig
  val ping: string * int -> unit
  val traceroute: string -> unit	(* uses TTL *)
  val traceroute_icmp: string -> unit	(* uses ICMP traceroute *)

  val complete_ping: {host: string, count: int, size: int option,
		      quiet: bool, interval: int (* ms *) option,
		      record_route: bool} -> unit

  val serve: {seconds: int} -> unit

  val make_ping_executable : string -> unit
 end


