  (** Path lists **)

    datatype path_list = PathList of string list

  (* make a search path list from a string of the form "p1:p2:...:pn" *)
    fun mkSearchPath s =
	  PathList(Strings.fields (fn #":" => true | _ => false) s)

    exception NoSuchFile

  (* return the first path p in the pathlist, such that p/name satisfies
   * the predicate.
   *)
    fun findFile (PathList l, pred) fname = let
	  fun find [] = raise NoSuchFile
	    | find (p::r) = let val pn = OS.Path.joinDirFile{dir=p, file=fname}
		in
		  if (pred pn) then pn else find r
		end
	  in
	    if (OS.Path.isAbsolute fname)
	      then if (pred fname) then fname else raise NoSuchFile
	      else find l
	  end

  (* return the list of paths p in the pathlist, such that p/name satisfies
   * the predicate.
   *)
    fun findFiles (PathList l, pred) fname = let
	  fun find ([], l) = rev l
	    | find (p::r, l) = let val pn = OS.Path.joinDirFile{dir=p, file=fname}
		in
		  if (pred pn) then find (r, pn::l) else find (r, l)
		end
	  in
	    if (OS.Path.isAbsolute fname)
              then if (pred fname) then [fname] else []
              else find (l, [])
	  end

