(* mccommon.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure MCCommon = 
  struct

   local  open Types Variables Lambda Absyn ErrorMsg
    in

    datatype simp = VARsimp of var | RECORDsimp of (label * simp) list

    fun mkRECORDpat (RECORDpat{fields, flex=false, typ, ...}) pats =
          RECORDpat {flex=false,typ=typ,
		     fields=List2.map2(fn((id,_),p)=>(id,p))(fields,pats)}
      | mkRECORDpat (RECORDpat{flex=true,...}) _ =
	       impossible "flex record passed to MCCommon.mkRECORDpat"
      | mkRECORDpat _ _ = impossible "non record passed to mkRECORDpat"

    datatype path
      = RECORDPATH of path list
      | PIPATH of int * path
      | VPIPATH of int * ty * path
      | VLENPATH of path
      | DELTAPATH of con * ty option * path
      | ROOTPATH
      

    type dconinfo = datacon * ty option

    datatype dectree
      = CASETEST of 
          path * Access.conrep list * (con * ty option * dectree) list 
               * dectree option
      | ABSTEST0 of path * dconinfo * dectree * dectree
      | ABSTEST1 of path * dconinfo * dectree * dectree
      | RHS of int
      | BIND of path * dectree
      
    fun conEq(DATACON{rep=r1,...},DATACON{rep=r2,...}) = r1 = r2
    fun conEq'((DATACON{rep=r1,...},_), (DATACON{rep=r2,...},_)) = r1 = r2

    fun constantEq (INTcon n, INTcon n') = n = n'
      | constantEq (WORDcon n, WORDcon n') = n = n'
      | constantEq (WORD32con n, WORD32con n') = n = n'
      | constantEq (REALcon r, REALcon r') = r = r'
      | constantEq (STRINGcon s, STRINGcon s') = s = s'
      | constantEq (VLENcon n, VLENcon n') = n = n'
      | constantEq (DATAcon(_,krep,_), DATAcon(_,krep',_)) = krep = krep'
      | constantEq _ = false

    fun pathEq(RECORDPATH(a::ar),RECORDPATH(b::br)) = 
	pathEq(a,b) andalso pathEq(RECORDPATH ar, RECORDPATH br)
      | pathEq(RECORDPATH nil, RECORDPATH nil) = true
      | pathEq(PIPATH(i1,p1),PIPATH(i2,p2)) = i1=i2 andalso pathEq(p1,p2)
      | pathEq(VPIPATH(i1,_,p1),VPIPATH(i2,_,p2)) = i1=i2 andalso pathEq(p1,p2)
      | pathEq(VLENPATH p1,VLENPATH p2) = pathEq(p1,p2)
      | pathEq(DELTAPATH(c1,_,p1),DELTAPATH(c2,_,p2)) = 
	               constantEq(c1,c2) andalso pathEq(p1,p2)
      | pathEq(ROOTPATH,ROOTPATH) = true
      | pathEq _ = false

    fun lookupPath (a, (b,c)::d) = 
           if pathEq(a,b) then c else lookupPath(a, d) 
      | lookupPath _ = ErrorMsg.impossible "mccommon.lookupPath"

    fun abstract x = false
    fun template x = false
    fun isAnException x = false
    fun signOfCon (DATACON{sign,...}) = sign
    fun unary (DATACON{const,...},_) = const

  end 
end


