(* Copyright 1994 by AT&T Bell Laboratories *)
(* fixup.sml *)

signature FIXUP =
sig
  val fixupStr: Modules.Structure -> unit
end

structure Fixup: FIXUP =
struct

(* imports *)
structure M = Modules
structure MU = ModuleUtil
structure T = Types
structure S = Symbol

val say = Control.Print.say


(* fixupStr travers a structure, destructively replacing the
datatypes' kind field with datacons whose relativized types have been
instantiated (thus getting rid of RELtycs to fix bug).  The structure
argument is assumed to be an INSTANCE, that has been produced by
instantiate. *)

(* THIS IS A TRICKY and BRUTE FORCE HACK!!! *)

fun fixupStr(str as M.INSTANCE{sign,subStrs,subFcts,types,origin,path}) =
    let val M.SIG{symbols=ref symbols,...} = sign
	fun fixDcon(T.DATACON{name,const,typ,rep,sign,orig}) =
	    T.DATACON{name=name,const=const,rep=rep,sign=sign,orig=orig,
		      typ=MU.transType str typ}
	fun fixComp sym =
	    case S.nameSpace sym
	      of S.TYCspace =>
		  (case MU.lookBindingTYC(str,SymPath.SPATH[sym])
		     of T.GENtyc{kind as ref(T.DATAtyc dcons),...} =>
			  kind := T.DATAtyc(map fixDcon dcons)
		      | _ => ())
	       | S.STRspace => fixupStr(MU.lookBindingSTR(str,SymPath.SPATH[sym])) 
	       | _ => ()
     in app fixComp symbols
    end
  | fixupStr _ = () (* was ErrorMsg.impossible "fixup" *)

end (* structure Fixup *)
