(* Copyright 1992 by AT&T Bell Laboratories *)
(***************************************************************************

  abstractfct.sig

  abstractBody takes a structure representing the formal application of a
  functor to free argument (also provided) and gives back the recipe to
  use when applying the functor.

 ***************************************************************************)

signature ABSTRACTFCT =
sig

  val abstractBody : 
     Modules.Structure *       (* body structure *)
     Modules.Structure *       (* parameter structure *)
     (Stamps.stamp -> bool) *  (* body locally bound stamps *)
     (Stamps.stamp -> bool)    (* parameter locally bound stamps *)
     -> {strseq : Modules.Structure list,
	 fctseq : Modules.Functor list,
	 tyseq : Types.tycon list,
	 str : Modules.Structure}

  val debugging : bool ref     (* turns on debugging messages *)

end

