(* hppaRules.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

(***** debug info *****
nonterm 0 : stm
nonterm 1 : ea
nonterm 2 : opnd
nonterm 3 : reg
nonterm 4 : freg

rule 1 : stm:	SEQ(stm,stm)	= stm_SEQ_s_s (0);
rule 2 : stm:	reg	= stm_reg (1);
rule 3 : stm:	freg	= stm_freg (1);
rule 4 : stm:	STORE8(ea,reg)	= stm_STORE8_ea_r (1);
rule 5 : stm:	STORE32(ea,reg)	= stm_STORE32_ea_r (1);
rule 6 : stm:	STORED(ea,freg)	= stm_STORED_ea_f (1);
rule 7 : stm:	BR	= stm_BR (1);
rule 8 : stm:	JMP(reg)	= stm_JMP_r (1);
rule 9 : stm:	GOTO(reg)	= stm_GOTO (1);
rule 10 : stm:	BCC(reg,reg)	= stm_BCC_r_r (1);
rule 11 : stm:	BCC(reg,LI)	= stm_BCC_r_i (1);
rule 12 : stm:	FBCC(freg,freg)	= stm_FBCC_f_f (1);
rule 13 : stm:	CALL(reg)	= stm_CALL_r (1);
rule 14 : stm:	RET	= stm_RET (1);
rule 15 : stm:	BARRIER	= stm_BARRIER (0);
rule 16 : stm:	TESTLIMIT(reg,reg)	= stm_TESTLIMIT_r_r (1);
rule 17 : stm:	CHECKLIMIT	= stm_CHECKLIMIT (1);
rule 18 : ea:	ADD(reg,reg)	= ea_ADD_r_r (0);
rule 19 : ea:	ADD(reg,LI)	= ea_ADD_r_LI (0);
rule 20 : ea:	ADD(LI,reg)	= ea_ADD_LI_r (0);
rule 21 : ea:	reg	= ea_reg (0);
rule 22 : opnd:	LI	= opnd_LI (0);
rule 23 : opnd:	reg	= opnd_r (0);
rule 24 : reg:	REG	= reg_REG (0);
rule 25 : reg:	LI	= reg_LI (1);
rule 26 : reg:	LI32	= reg_LI32 (1);
rule 27 : reg:	MV(REG,reg)	= reg_MV_REG_r (1);
rule 28 : reg:	LDREGMASK	= reg_LDREGMASK (1);
rule 29 : reg:	LADDR	= reg_LADDR (1);
rule 30 : reg:	LBASE(reg)	= reg_LBASE_r (1);
rule 31 : reg:	LOAD8(ea)	= reg_LOAD8_ea (1);
rule 32 : reg:	LOAD32(ea)	= reg_LOAD32_ea (1);
rule 33 : reg:	ADD(reg,opnd)	= reg_ADD_r_o (1);
rule 34 : reg:	ADDT(reg,opnd)	= reg_ADD_r_o (1);
rule 35 : reg:	SUB(opnd,reg)	= reg_SUB_o_r (1);
rule 36 : reg:	SUBT(opnd,reg)	= reg_SUB_o_r (1);
rule 37 : reg:	ANDB(reg,reg)	= reg_ARITH_r_r (1);
rule 38 : reg:	ORB(reg,reg)	= reg_ARITH_r_r (1);
rule 39 : reg:	XORB(reg,reg)	= reg_ARITH_r_r (1);
rule 40 : reg:	MULU(reg,reg)	= reg_ARITH_r_r (1);
rule 41 : reg:	MULT(reg,reg)	= reg_ARITH_r_r (1);
rule 42 : reg:	DIVU(reg,reg)	= reg_ARITH_r_r (1);
rule 43 : reg:	DIVT(reg,reg)	= reg_ARITH_r_r (1);
rule 44 : reg:	SRA(reg,opnd)	= reg_RSHIFT_r_o (1);
rule 45 : reg:	SRL(reg,opnd)	= reg_RSHIFT_r_o (1);
rule 46 : reg:	SLL(reg,opnd)	= reg_SLL_r_o (1);
rule 47 : reg:	ADD(opnd,reg)	= reg_ADD_o_r (1);
rule 48 : reg:	ADDT(opnd,reg)	= reg_ADD_o_r (1);
rule 49 : reg:	SEQ(stm,reg)	= reg_SEQ_s_r (1);
rule 50 : freg:	LOADD(ea)	= freg_LOADD_ea (1);
rule 51 : freg:	FREG	= freg_FREG (0);
rule 52 : freg:	FMV(FREG,freg)	= freg_FMV_FREG_f (1);
rule 53 : freg:	FADDD(freg,freg)	= freg_FARITH_f_f (3);
rule 54 : freg:	FSUBD(freg,freg)	= freg_FARITH_f_f (3);
rule 55 : freg:	FMULD(freg,freg)	= freg_FARITH_f_f (3);
rule 56 : freg:	FDIVD(freg,freg)	= freg_FARITH_f_f (3);
rule 57 : freg:	FABSD(freg)	= freg_FARITH_f (1);
rule 58 : freg:	FNEGD(freg)	= freg_FARITH_f (1);
rule 59 : freg:	CVTI2D(reg)	= freg_CVTI2D_r (1);
rule 60 : freg:	SEQ(stm,freg)	= freg_SEQ_s_f (1);
**********************)


structure HppaburmOps = struct
  datatype ops = REG
	       | FREG
	       | LI
	       | LI32
	       | MV
	       | FMV
	       | LADDR
	       | LBASE
	       | LOAD8
	       | LOAD32
	       | LOADD
	       | STORE8
	       | STORE32
	       | STORED
	       | ADD
	       | SUB
	       | MULU
	       | DIVU
	       | ADDT
	       | SUBT
	       | MULT
	       | DIVT
	       | ANDB
	       | ORB
	       | XORB
	       | SRA
	       | SRL
	       | SLL
	       | FADDD
	       | FSUBD
	       | FMULD
	       | FDIVD
	       | FABSD
	       | FNEGD
	       | CVTI2D
	       | BR
	       | JMP
	       | GOTO
	       | BCC
	       | FBCC
	       | CALL
	       | RET
	       | SEQ
	       | BARRIER
	       | TESTLIMIT
	       | CHECKLIMIT
	       | LDREGMASK
end


signature HPPABURM_INPUT_SPEC = sig
  type tree
  val opchildren : tree -> HppaburmOps.ops * (tree list)
end


signature HPPABURM = sig
  exception NoMatch
  type tree
  datatype rule = stm_SEQ_s_s of (rule * tree) * (rule * tree)
		| stm_reg of (rule * tree)
		| stm_freg of (rule * tree)
		| stm_STORE8_ea_r of (rule * tree) * (rule * tree)
		| stm_STORE32_ea_r of (rule * tree) * (rule * tree)
		| stm_STORED_ea_f of (rule * tree) * (rule * tree)
		| stm_BR
		| stm_JMP_r of (rule * tree)
		| stm_GOTO of (rule * tree)
		| stm_BCC_r_r of (rule * tree) * (rule * tree)
		| stm_BCC_r_i of (rule * tree)
		| stm_FBCC_f_f of (rule * tree) * (rule * tree)
		| stm_CALL_r of (rule * tree)
		| stm_RET
		| stm_BARRIER
		| stm_TESTLIMIT_r_r of (rule * tree) * (rule * tree)
		| stm_CHECKLIMIT
		| ea_ADD_r_r of (rule * tree) * (rule * tree)
		| ea_ADD_r_LI of (rule * tree)
		| ea_ADD_LI_r of (rule * tree)
		| ea_reg of (rule * tree)
		| opnd_LI
		| opnd_r of (rule * tree)
		| reg_REG
		| reg_LI
		| reg_LI32
		| reg_MV_REG_r of (rule * tree)
		| reg_LDREGMASK
		| reg_LADDR
		| reg_LBASE_r of (rule * tree)
		| reg_LOAD8_ea of (rule * tree)
		| reg_LOAD32_ea of (rule * tree)
		| reg_ADD_r_o of (rule * tree) * (rule * tree)
		| reg_SUB_o_r of (rule * tree) * (rule * tree)
		| reg_ARITH_r_r of (rule * tree) * (rule * tree)
		| reg_RSHIFT_r_o of (rule * tree) * (rule * tree)
		| reg_SLL_r_o of (rule * tree) * (rule * tree)
		| reg_ADD_o_r of (rule * tree) * (rule * tree)
		| reg_SEQ_s_r of (rule * tree) * (rule * tree)
		| freg_LOADD_ea of (rule * tree)
		| freg_FREG
		| freg_FMV_FREG_f of (rule * tree)
		| freg_FARITH_f_f of (rule * tree) * (rule * tree)
		| freg_FARITH_f of (rule * tree)
		| freg_CVTI2D_r of (rule * tree)
		| freg_SEQ_s_f of (rule * tree) * (rule * tree)
  val reduce : tree -> rule * tree
  val ruleToString : rule -> string
end


functor HppaburmGen (In : HPPABURM_INPUT_SPEC) : HPPABURM =
  struct

    type tree = In.tree

    exception NoMatch
  datatype rule = stm_SEQ_s_s of (rule * tree) * (rule * tree)
		| stm_reg of (rule * tree)
		| stm_freg of (rule * tree)
		| stm_STORE8_ea_r of (rule * tree) * (rule * tree)
		| stm_STORE32_ea_r of (rule * tree) * (rule * tree)
		| stm_STORED_ea_f of (rule * tree) * (rule * tree)
		| stm_BR
		| stm_JMP_r of (rule * tree)
		| stm_GOTO of (rule * tree)
		| stm_BCC_r_r of (rule * tree) * (rule * tree)
		| stm_BCC_r_i of (rule * tree)
		| stm_FBCC_f_f of (rule * tree) * (rule * tree)
		| stm_CALL_r of (rule * tree)
		| stm_RET
		| stm_BARRIER
		| stm_TESTLIMIT_r_r of (rule * tree) * (rule * tree)
		| stm_CHECKLIMIT
		| ea_ADD_r_r of (rule * tree) * (rule * tree)
		| ea_ADD_r_LI of (rule * tree)
		| ea_ADD_LI_r of (rule * tree)
		| ea_reg of (rule * tree)
		| opnd_LI
		| opnd_r of (rule * tree)
		| reg_REG
		| reg_LI
		| reg_LI32
		| reg_MV_REG_r of (rule * tree)
		| reg_LDREGMASK
		| reg_LADDR
		| reg_LBASE_r of (rule * tree)
		| reg_LOAD8_ea of (rule * tree)
		| reg_LOAD32_ea of (rule * tree)
		| reg_ADD_r_o of (rule * tree) * (rule * tree)
		| reg_SUB_o_r of (rule * tree) * (rule * tree)
		| reg_ARITH_r_r of (rule * tree) * (rule * tree)
		| reg_RSHIFT_r_o of (rule * tree) * (rule * tree)
		| reg_SLL_r_o of (rule * tree) * (rule * tree)
		| reg_ADD_o_r of (rule * tree) * (rule * tree)
		| reg_SEQ_s_r of (rule * tree) * (rule * tree)
		| freg_LOADD_ea of (rule * tree)
		| freg_FREG
		| freg_FMV_FREG_f of (rule * tree)
		| freg_FARITH_f_f of (rule * tree) * (rule * tree)
		| freg_FARITH_f of (rule * tree)
		| freg_CVTI2D_r of (rule * tree)
		| freg_SEQ_s_f of (rule * tree) * (rule * tree)


    fun ruleToString (stm_SEQ_s_s _) = "stm_SEQ_s_s"
      | ruleToString(stm_reg _) = "stm_reg"
      | ruleToString(stm_freg _) = "stm_freg"
      | ruleToString(stm_STORE8_ea_r _) = "stm_STORE8_ea_r"
      | ruleToString(stm_STORE32_ea_r _) = "stm_STORE32_ea_r"
      | ruleToString(stm_STORED_ea_f _) = "stm_STORED_ea_f"
      | ruleToString(stm_BR) = "stm_BR"
      | ruleToString(stm_JMP_r _) = "stm_JMP_r"
      | ruleToString(stm_GOTO _) = "stm_GOTO"
      | ruleToString(stm_BCC_r_r _) = "stm_BCC_r_r"
      | ruleToString(stm_BCC_r_i _) = "stm_BCC_r_i"
      | ruleToString(stm_FBCC_f_f _) = "stm_FBCC_f_f"
      | ruleToString(stm_CALL_r _) = "stm_CALL_r"
      | ruleToString(stm_RET) = "stm_RET"
      | ruleToString(stm_BARRIER) = "stm_BARRIER"
      | ruleToString(stm_TESTLIMIT_r_r _) = "stm_TESTLIMIT_r_r"
      | ruleToString(stm_CHECKLIMIT) = "stm_CHECKLIMIT"
      | ruleToString(ea_ADD_r_r _) = "ea_ADD_r_r"
      | ruleToString(ea_ADD_r_LI _) = "ea_ADD_r_LI"
      | ruleToString(ea_ADD_LI_r _) = "ea_ADD_LI_r"
      | ruleToString(ea_reg _) = "ea_reg"
      | ruleToString(opnd_LI) = "opnd_LI"
      | ruleToString(opnd_r _) = "opnd_r"
      | ruleToString(reg_REG) = "reg_REG"
      | ruleToString(reg_LI) = "reg_LI"
      | ruleToString(reg_LI32) = "reg_LI32"
      | ruleToString(reg_MV_REG_r _) = "reg_MV_REG_r"
      | ruleToString(reg_LDREGMASK) = "reg_LDREGMASK"
      | ruleToString(reg_LADDR) = "reg_LADDR"
      | ruleToString(reg_LBASE_r _) = "reg_LBASE_r"
      | ruleToString(reg_LOAD8_ea _) = "reg_LOAD8_ea"
      | ruleToString(reg_LOAD32_ea _) = "reg_LOAD32_ea"
      | ruleToString(reg_ADD_r_o _) = "reg_ADD_r_o"
      | ruleToString(reg_SUB_o_r _) = "reg_SUB_o_r"
      | ruleToString(reg_ARITH_r_r _) = "reg_ARITH_r_r"
      | ruleToString(reg_RSHIFT_r_o _) = "reg_RSHIFT_r_o"
      | ruleToString(reg_SLL_r_o _) = "reg_SLL_r_o"
      | ruleToString(reg_ADD_o_r _) = "reg_ADD_o_r"
      | ruleToString(reg_SEQ_s_r _) = "reg_SEQ_s_r"
      | ruleToString(freg_LOADD_ea _) = "freg_LOADD_ea"
      | ruleToString(freg_FREG) = "freg_FREG"
      | ruleToString(freg_FMV_FREG_f _) = "freg_FMV_FREG_f"
      | ruleToString(freg_FARITH_f_f _) = "freg_FARITH_f_f"
      | ruleToString(freg_FARITH_f _) = "freg_FARITH_f"
      | ruleToString(freg_CVTI2D_r _) = "freg_CVTI2D_r"
      | ruleToString(freg_SEQ_s_f _) = "freg_SEQ_s_f"


    type s_cost = int Array.array
    type s_rule = int Array.array
    datatype s_node =
      N_REG
    | N_FREG
    | N_LI
    | N_LI32
    | N_MV		of s_tree * s_tree
    | N_FMV		of s_tree * s_tree
    | N_LADDR
    | N_LBASE		of s_tree
    | N_LOAD8		of s_tree
    | N_LOAD32		of s_tree
    | N_LOADD		of s_tree
    | N_STORE8		of s_tree * s_tree
    | N_STORE32		of s_tree * s_tree
    | N_STORED		of s_tree * s_tree
    | N_ADD		of s_tree * s_tree
    | N_SUB		of s_tree * s_tree
    | N_MULU		of s_tree * s_tree
    | N_DIVU		of s_tree * s_tree
    | N_ADDT		of s_tree * s_tree
    | N_SUBT		of s_tree * s_tree
    | N_MULT		of s_tree * s_tree
    | N_DIVT		of s_tree * s_tree
    | N_ANDB		of s_tree * s_tree
    | N_ORB		of s_tree * s_tree
    | N_XORB		of s_tree * s_tree
    | N_SRA		of s_tree * s_tree
    | N_SRL		of s_tree * s_tree
    | N_SLL		of s_tree * s_tree
    | N_FADDD		of s_tree * s_tree
    | N_FSUBD		of s_tree * s_tree
    | N_FMULD		of s_tree * s_tree
    | N_FDIVD		of s_tree * s_tree
    | N_FABSD		of s_tree
    | N_FNEGD		of s_tree
    | N_CVTI2D		of s_tree
    | N_BR
    | N_JMP		of s_tree
    | N_GOTO		of s_tree
    | N_BCC		of s_tree * s_tree
    | N_FBCC		of s_tree * s_tree
    | N_CALL		of s_tree
    | N_RET
    | N_SEQ		of s_tree * s_tree
    | N_BARRIER
    | N_TESTLIMIT		of s_tree * s_tree
    | N_CHECKLIMIT
    | N_LDREGMASK
    withtype s_tree = s_cost * s_rule * s_node * tree


    val sub = System.Unsafe.subscript
    val update = System.Unsafe.update
    val leaf_N_REG =
      (Array.fromList [1,0,0,0,16383],
       Array.fromList [2,21,23,24,0],
       N_REG)
    val leaf_N_FREG =
      (Array.fromList [1,16383,16383,16383,0],
       Array.fromList [3,0,0,0,51],
       N_FREG)
    val leaf_N_LI =
      (Array.fromList [2,1,0,1,16383],
       Array.fromList [2,21,22,25,0],
       N_LI)
    val leaf_N_LI32 =
      (Array.fromList [2,1,1,1,16383],
       Array.fromList [2,21,23,26,0],
       N_LI32)
    val leaf_N_LADDR =
      (Array.fromList [2,1,1,1,16383],
       Array.fromList [2,21,23,29,0],
       N_LADDR)
    val leaf_N_BR =
      (Array.fromList [1,16383,16383,16383,16383],
       Array.fromList [7,0,0,0,0],
       N_BR)
    val leaf_N_RET =
      (Array.fromList [1,16383,16383,16383,16383],
       Array.fromList [14,0,0,0,0],
       N_RET)
    val leaf_N_BARRIER =
      (Array.fromList [0,16383,16383,16383,16383],
       Array.fromList [15,0,0,0,0],
       N_BARRIER)
    val leaf_N_CHECKLIMIT =
      (Array.fromList [1,16383,16383,16383,16383],
       Array.fromList [17,0,0,0,0],
       N_CHECKLIMIT)
    val leaf_N_LDREGMASK =
      (Array.fromList [2,1,1,1,16383],
       Array.fromList [2,21,23,28,0],
       N_LDREGMASK)
    val s_c_nothing = Array.array (5,16383)
    val s_r_nothing = Array.array (5,0)


    fun rec_label (tree : In.tree) =
      let
	fun closure_reg (s_c, s_r, c) =
	  (if c + 0 < sub (s_c,2) then
	     (update (s_c,2,c + 0);
	      update (s_r,2,23)
	     )
	   else
	     ();
	   if c + 0 < sub (s_c,1) then
	     (update (s_c,1,c + 0);
	      update (s_r,1,21)
	     )
	   else
	     ();
	   if c + 1 < sub (s_c,0) then
	     (update (s_c,0,c + 1);
	      update (s_r,0,2)
	     )
	   else
	     ()
	  )
	and closure_freg (s_c, s_r, c) =
	  (if c + 1 < sub (s_c,0) then
	     (update (s_c,0,c + 1);
	      update (s_r,0,3)
	     )
	   else
	     ()
	  )
	val (term, children) = In.opchildren tree
	val (s_c, s_r, t) = case term of
	  HppaburmOps.REG =>
	    leaf_N_REG
	| HppaburmOps.FREG =>
	    leaf_N_FREG
	| HppaburmOps.LI =>
	    leaf_N_LI
	| HppaburmOps.LI32 =>
	    leaf_N_LI32
	| HppaburmOps.MV =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((_,_,N_REG,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 27);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_MV (t0,t1)) end
	    end
	| HppaburmOps.FMV =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((_,_,N_FREG,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 52);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FMV (t0,t1)) end
	    end
	| HppaburmOps.LADDR =>
	    leaf_N_LADDR
	| HppaburmOps.LBASE =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 30);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_LBASE (t0)) end
	    end
	| HppaburmOps.LOAD8 =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 then
			 let
			   val c = sub (s0_c,1)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 31);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_LOAD8 (t0)) end
	    end
	| HppaburmOps.LOAD32 =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 then
			 let
			   val c = sub (s0_c,1)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 32);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_LOAD32 (t0)) end
	    end
	| HppaburmOps.LOADD =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 then
			 let
			   val c = sub (s0_c,1)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 50);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_LOADD (t0)) end
	    end
	| HppaburmOps.STORE8 =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 4);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_STORE8 (t0,t1)) end
	    end
	| HppaburmOps.STORE32 =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 5);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_STORE32 (t0,t1)) end
	    end
	| HppaburmOps.STORED =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,4)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 6);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_STORED (t0,t1)) end
	    end
	| HppaburmOps.ADD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 47);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,3)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 33);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 0 < sub (s_c,1) then
			     (update (s_c, 1, c + 0);
			      update (s_r, 1, 18);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_LI,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 0 < sub (s_c,1) then
			     (update (s_c, 1, c + 0);
			      update (s_r, 1, 19);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		case z of
		    ((_,_,N_LI,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 0 < sub (s_c,1) then
			     (update (s_c, 1, c + 0);
			      update (s_r, 1, 20);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ADD (t0,t1)) end
	    end
	| HppaburmOps.SUB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 35);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SUB (t0,t1)) end
	    end
	| HppaburmOps.MULU =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 40);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_MULU (t0,t1)) end
	    end
	| HppaburmOps.DIVU =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 42);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_DIVU (t0,t1)) end
	    end
	| HppaburmOps.ADDT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 48);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,3)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 34);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ADDT (t0,t1)) end
	    end
	| HppaburmOps.SUBT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 36);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SUBT (t0,t1)) end
	    end
	| HppaburmOps.MULT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 41);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_MULT (t0,t1)) end
	    end
	| HppaburmOps.DIVT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 43);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_DIVT (t0,t1)) end
	    end
	| HppaburmOps.ANDB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 37);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ANDB (t0,t1)) end
	    end
	| HppaburmOps.ORB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 38);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ORB (t0,t1)) end
	    end
	| HppaburmOps.XORB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 39);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_XORB (t0,t1)) end
	    end
	| HppaburmOps.SRA =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 44);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SRA (t0,t1)) end
	    end
	| HppaburmOps.SRL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 45);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SRL (t0,t1)) end
	    end
	| HppaburmOps.SLL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 46);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SLL (t0,t1)) end
	    end
	| HppaburmOps.FADDD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,4) + sub (s1_c,4)
			 in
			   if c + 3 < sub (s_c,4) then
			     (update (s_c, 4, c + 3);
			      update (s_r, 4, 53);
			      closure_freg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FADDD (t0,t1)) end
	    end
	| HppaburmOps.FSUBD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,4) + sub (s1_c,4)
			 in
			   if c + 3 < sub (s_c,4) then
			     (update (s_c, 4, c + 3);
			      update (s_r, 4, 54);
			      closure_freg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FSUBD (t0,t1)) end
	    end
	| HppaburmOps.FMULD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,4) + sub (s1_c,4)
			 in
			   if c + 3 < sub (s_c,4) then
			     (update (s_c, 4, c + 3);
			      update (s_r, 4, 55);
			      closure_freg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FMULD (t0,t1)) end
	    end
	| HppaburmOps.FDIVD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,4) + sub (s1_c,4)
			 in
			   if c + 3 < sub (s_c,4) then
			     (update (s_c, 4, c + 3);
			      update (s_r, 4, 56);
			      closure_freg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FDIVD (t0,t1)) end
	    end
	| HppaburmOps.FABSD =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 57);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FABSD (t0)) end
	    end
	| HppaburmOps.FNEGD =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 58);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FNEGD (t0)) end
	    end
	| HppaburmOps.CVTI2D =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 59);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_CVTI2D (t0)) end
	    end
	| HppaburmOps.BR =>
	    leaf_N_BR
	| HppaburmOps.JMP =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 8);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_JMP (t0)) end
	    end
	| HppaburmOps.GOTO =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 9);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_GOTO (t0)) end
	    end
	| HppaburmOps.BCC =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_LI,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 11);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 10);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_BCC (t0,t1)) end
	    end
	| HppaburmOps.FBCC =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,4) + sub (s1_c,4)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 12);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FBCC (t0,t1)) end
	    end
	| HppaburmOps.CALL =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 13);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_CALL (t0)) end
	    end
	| HppaburmOps.RET =>
	    leaf_N_RET
	| HppaburmOps.SEQ =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 60);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 49);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 0 < sub (s_c,0) then
			     (update (s_c, 0, c + 0);
			      update (s_r, 0, 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SEQ (t0,t1)) end
	    end
	| HppaburmOps.BARRIER =>
	    leaf_N_BARRIER
	| HppaburmOps.TESTLIMIT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 16);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_TESTLIMIT (t0,t1)) end
	    end
	| HppaburmOps.CHECKLIMIT =>
	    leaf_N_CHECKLIMIT
	| HppaburmOps.LDREGMASK =>
	    leaf_N_LDREGMASK
      in
        (s_c, s_r, t, tree)
      end

    fun doreduce (stree : s_tree, nt) =
      let
	val (s_c, s_r, _, tree) = stree
	val cost = sub (s_c, nt)
      in
	if cost=16383 then
	  (print ("No Match on nonterminal "^(makestring nt)^"\n");
	   print "Possibilities were :\n";
	   let
	     fun loop n =
	       let
	         val c = Array.sub (s_c, n);
	         val r = Array.sub (s_r, n);
	       in
	         if c=16383 then () else
	           print ("rule "^(makestring r)^" with cost "
	                  ^(makestring c)^"\n");
	         loop (n+1)
	       end
	   in
	     (loop 0) handle General.Subscript => ()
	   end;
	   raise NoMatch)
	else
	  let
	    val rulensons =
	      case (sub (s_r, nt), stree) of
		(1, (_,_,N_SEQ (t0,t1),_)) =>
		  (stm_SEQ_s_s (doreduce (t0,0), doreduce (t1,0)))
	      | (2, t0) =>
		  (stm_reg (doreduce (t0,3)))
	      | (3, t0) =>
		  (stm_freg (doreduce (t0,4)))
	      | (4, (_,_,N_STORE8 (t0,t1),_)) =>
		  (stm_STORE8_ea_r (doreduce (t0,1), doreduce (t1,3)))
	      | (5, (_,_,N_STORE32 (t0,t1),_)) =>
		  (stm_STORE32_ea_r (doreduce (t0,1), doreduce (t1,3)))
	      | (6, (_,_,N_STORED (t0,t1),_)) =>
		  (stm_STORED_ea_f (doreduce (t0,1), doreduce (t1,4)))
	      | (7, (_,_,N_BR,_)) =>
		  (stm_BR)
	      | (8, (_,_,N_JMP t0,_)) =>
		  (stm_JMP_r (doreduce (t0,3)))
	      | (9, (_,_,N_GOTO t0,_)) =>
		  (stm_GOTO (doreduce (t0,3)))
	      | (10, (_,_,N_BCC (t0,t1),_)) =>
		  (stm_BCC_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (11, (_,_,N_BCC (t0,(_,_,N_LI,_)),_)) =>
		  (stm_BCC_r_i (doreduce (t0,3)))
	      | (12, (_,_,N_FBCC (t0,t1),_)) =>
		  (stm_FBCC_f_f (doreduce (t0,4), doreduce (t1,4)))
	      | (13, (_,_,N_CALL t0,_)) =>
		  (stm_CALL_r (doreduce (t0,3)))
	      | (14, (_,_,N_RET,_)) =>
		  (stm_RET)
	      | (15, (_,_,N_BARRIER,_)) =>
		  (stm_BARRIER)
	      | (16, (_,_,N_TESTLIMIT (t0,t1),_)) =>
		  (stm_TESTLIMIT_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (17, (_,_,N_CHECKLIMIT,_)) =>
		  (stm_CHECKLIMIT)
	      | (18, (_,_,N_ADD (t0,t1),_)) =>
		  (ea_ADD_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (19, (_,_,N_ADD (t0,(_,_,N_LI,_)),_)) =>
		  (ea_ADD_r_LI (doreduce (t0,3)))
	      | (20, (_,_,N_ADD ((_,_,N_LI,_),t0),_)) =>
		  (ea_ADD_LI_r (doreduce (t0,3)))
	      | (21, t0) =>
		  (ea_reg (doreduce (t0,3)))
	      | (22, (_,_,N_LI,_)) =>
		  (opnd_LI)
	      | (23, t0) =>
		  (opnd_r (doreduce (t0,3)))
	      | (24, (_,_,N_REG,_)) =>
		  (reg_REG)
	      | (25, (_,_,N_LI,_)) =>
		  (reg_LI)
	      | (26, (_,_,N_LI32,_)) =>
		  (reg_LI32)
	      | (27, (_,_,N_MV ((_,_,N_REG,_),t0),_)) =>
		  (reg_MV_REG_r (doreduce (t0,3)))
	      | (28, (_,_,N_LDREGMASK,_)) =>
		  (reg_LDREGMASK)
	      | (29, (_,_,N_LADDR,_)) =>
		  (reg_LADDR)
	      | (30, (_,_,N_LBASE t0,_)) =>
		  (reg_LBASE_r (doreduce (t0,3)))
	      | (31, (_,_,N_LOAD8 t0,_)) =>
		  (reg_LOAD8_ea (doreduce (t0,1)))
	      | (32, (_,_,N_LOAD32 t0,_)) =>
		  (reg_LOAD32_ea (doreduce (t0,1)))
	      | (33, (_,_,N_ADD (t0,t1),_)) =>
		  (reg_ADD_r_o (doreduce (t0,3), doreduce (t1,2)))
	      | (34, (_,_,N_ADDT (t0,t1),_)) =>
		  (reg_ADD_r_o (doreduce (t0,3), doreduce (t1,2)))
	      | (35, (_,_,N_SUB (t0,t1),_)) =>
		  (reg_SUB_o_r (doreduce (t0,2), doreduce (t1,3)))
	      | (36, (_,_,N_SUBT (t0,t1),_)) =>
		  (reg_SUB_o_r (doreduce (t0,2), doreduce (t1,3)))
	      | (37, (_,_,N_ANDB (t0,t1),_)) =>
		  (reg_ARITH_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (38, (_,_,N_ORB (t0,t1),_)) =>
		  (reg_ARITH_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (39, (_,_,N_XORB (t0,t1),_)) =>
		  (reg_ARITH_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (40, (_,_,N_MULU (t0,t1),_)) =>
		  (reg_ARITH_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (41, (_,_,N_MULT (t0,t1),_)) =>
		  (reg_ARITH_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (42, (_,_,N_DIVU (t0,t1),_)) =>
		  (reg_ARITH_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (43, (_,_,N_DIVT (t0,t1),_)) =>
		  (reg_ARITH_r_r (doreduce (t0,3), doreduce (t1,3)))
	      | (44, (_,_,N_SRA (t0,t1),_)) =>
		  (reg_RSHIFT_r_o (doreduce (t0,3), doreduce (t1,2)))
	      | (45, (_,_,N_SRL (t0,t1),_)) =>
		  (reg_RSHIFT_r_o (doreduce (t0,3), doreduce (t1,2)))
	      | (46, (_,_,N_SLL (t0,t1),_)) =>
		  (reg_SLL_r_o (doreduce (t0,3), doreduce (t1,2)))
	      | (47, (_,_,N_ADD (t0,t1),_)) =>
		  (reg_ADD_o_r (doreduce (t0,2), doreduce (t1,3)))
	      | (48, (_,_,N_ADDT (t0,t1),_)) =>
		  (reg_ADD_o_r (doreduce (t0,2), doreduce (t1,3)))
	      | (49, (_,_,N_SEQ (t0,t1),_)) =>
		  (reg_SEQ_s_r (doreduce (t0,0), doreduce (t1,3)))
	      | (50, (_,_,N_LOADD t0,_)) =>
		  (freg_LOADD_ea (doreduce (t0,1)))
	      | (51, (_,_,N_FREG,_)) =>
		  (freg_FREG)
	      | (52, (_,_,N_FMV ((_,_,N_FREG,_),t0),_)) =>
		  (freg_FMV_FREG_f (doreduce (t0,4)))
	      | (53, (_,_,N_FADDD (t0,t1),_)) =>
		  (freg_FARITH_f_f (doreduce (t0,4), doreduce (t1,4)))
	      | (54, (_,_,N_FSUBD (t0,t1),_)) =>
		  (freg_FARITH_f_f (doreduce (t0,4), doreduce (t1,4)))
	      | (55, (_,_,N_FMULD (t0,t1),_)) =>
		  (freg_FARITH_f_f (doreduce (t0,4), doreduce (t1,4)))
	      | (56, (_,_,N_FDIVD (t0,t1),_)) =>
		  (freg_FARITH_f_f (doreduce (t0,4), doreduce (t1,4)))
	      | (57, (_,_,N_FABSD t0,_)) =>
		  (freg_FARITH_f (doreduce (t0,4)))
	      | (58, (_,_,N_FNEGD t0,_)) =>
		  (freg_FARITH_f (doreduce (t0,4)))
	      | (59, (_,_,N_CVTI2D t0,_)) =>
		  (freg_CVTI2D_r (doreduce (t0,3)))
	      | (60, (_,_,N_SEQ (t0,t1),_)) =>
		  (freg_SEQ_s_f (doreduce (t0,0), doreduce (t1,4)))
	      | _ => raise NoMatch (* bug in iburg *)
	  in
	    (rulensons, tree)
	  end
      end

    fun reduce (tree) =
      doreduce (rec_label (tree), 0)
  end


