(* time.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure TimeIt = struct
  structure T = System.Timer
  fun timeit(msg,f) = 
      if !System.Control.timings then 
	let
	    val start = T.start_timer()
	    val ans = f()
	    val time = T.check_timer start
	in
	    outputc std_out (msg ^ T.makestring time ^ "\n");
	    ans
	end
      else f()
end

      

