(* Copyright 1992 by AT&T Bell Laboratories *)
(* env/statenv.sml *)

structure StaticEnv : STATICENV =
struct

  type staticEnv = Modules.env
  type binding = Modules.binding

  exception Unbound = Env.Unbound
  exception SpecialEnv = Env.SpecialEnv
  val empty = Env.empty
  val look = Env.look
(*  fun look (a as (_,sym)) =
      (print "[looking up "; print (Symbol.name sym); flush_out std_out;
       Env.look a before print "]\n")
*)
  val bind = Env.bind
  val open' = Env.open'
  val special = Env.special
  val atop = Env.atop
  val consolidate = Env.consolidate
  val app = Env.app
  val map = Env.map

  fun strToEnv(senv,sym) =
      case look(senv,sym)
        of Modules.STRbind(Modules.STRvar{access=p,binding=str,...}) =>
	    ModuleUtil.makeEnv (str, p)
         | _ => raise Unbound

end  (* structure StaticEnv *)
