(* Copyright 1992 by AT&T Bell Laboratories *)
(* env/statenv.sig *)

signature STATICENV =
sig
  type staticEnv
  type binding
  exception Unbound  
  exception SpecialEnv
  val empty: staticEnv
  val look: staticEnv * Symbol.symbol -> binding
  val bind: Symbol.symbol * binding * staticEnv -> staticEnv
  val open': staticEnv * (binding -> binding) * staticEnv -> staticEnv
  val special: (Symbol.symbol -> binding) * (unit -> Symbol.symbol list) option
               -> staticEnv
  val atop: staticEnv * staticEnv -> staticEnv
  val consolidate: staticEnv -> staticEnv
  val app: (Symbol.symbol * binding -> unit) -> staticEnv -> unit
  val map: (binding -> binding) -> staticEnv -> staticEnv
  val strToEnv : staticEnv * Symbol.symbol -> staticEnv
end
