(* scenv.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure SCEnv : SCENV =
struct
  structure E = Environment

  structure SCS = SCStaticEnv

  fun SC { static, dynamic, symbolic } =
      { static = SCS.SC static, dynamic = dynamic, symbolic = symbolic }
  fun unSC { static, dynamic, symbolic } =
      { static = SCS.unSC static, dynamic = dynamic, symbolic = symbolic }

  structure Env =
  struct
      type staticEnv = SCStaticEnv.staticEnv
      type dynenv = E.dynenv
      type symenv = E.symenv
      type environment = {static: staticEnv, dynamic: dynenv, symbolic: symenv}
      type symbol = E.symbol
      val emptyEnv = SC E.emptyEnv
      fun staticPart { static, dynamic, symbolic } = static
      fun dynamicPart { static, dynamic, symbolic } = dynamic
      fun symbolicPart { static, dynamic, symbolic } = symbolic
      fun mkenv x = x
      fun exports (stat, pid) = let
	  val (se, ele, epid) = E.exports (SCS.unSC stat, pid)
      in
	  (SCS.SC se, ele, epid)
      end
      fun layerEnv({static=s1,dynamic=d1,symbolic=sy1},
		   {static=s2,dynamic=d2,symbolic=sy2}) =
	  {static=SCS.atop(s1,s2),
	   dynamic=DynamicEnv.atop(d1,d2),
	   symbolic=SymbolicEnv.atop(sy1,sy2)}
      val layerStatic = SCS.atop
      val layerSymbolic = SymbolicEnv.atop
      fun filterEnv(e,l) = SC(E.filterEnv(unSC e,l))
      fun filterStaticEnv(s,l) = SCS.SC(E.filterStaticEnv(SCS.unSC s,l))
      fun concatEnv(a,b) = SC(E.concatEnv(unSC a, unSC b))
      fun consolidateEnv e = SC(E.consolidateEnv(unSC e))
      fun consolidateStatic e = SCS.SC(E.consolidateStatic(SCS.unSC e))
      val consolidateSymbolic = SymbolicEnv.consolidate
      val catalogEnv = E.catalogEnv o SCS.unSC

      datatype cmEnv =
	  CM_NONE
	| CM_ENV of Symbol.symbol -> cmEnv

      fun coerceCmEnv E.CM_NONE = CM_NONE
	| coerceCmEnv (E.CM_ENV f) = CM_ENV (coerceCmEnv o f)

      fun cmEnvOfModule e id = coerceCmEnv (E.cmEnvOfModule (SCS.unSC e) id)

      exception EnvOfStructure = E.EnvOfStructure
      fun envOfStructure(e,id) = SCS.SC(E.envOfStructure(SCS.unSC e, id))

      val describe = E.describe o SCS.unSC

      fun coerce (to,unto) {get,set} = {get=to o get,set = set o unto}
      val coreEnvRef = coerce (SCS.SC,SCS.unSC) E.coreEnvRef
      val topLevelEnvRef = coerce(SC,unSC) E.topLevelEnvRef
      val pervasiveEnvRef = coerce(SC,unSC) E.pervasiveEnvRef
      val primEnv = SCS.SC E.primEnv
    end

end
