(* moduletable.sml
 *
 * COPYRIGHT (c) 1995 AT&T  Bell Laboratories.
 *)

signature MODULE_TABLE =
sig
  type 'a table
  val empty : 'a table
  val bind : ModuleId.modId * 'a * 'a table -> 'a table
  val look : ModuleId.modId * 'a table -> 'a option
  val app : (ModuleId.modId * 'a -> unit) -> 'a table -> unit
end

structure ModuleTable : MODULE_TABLE = 
struct

  (* simple association list representation of finite mappings over
     modId's *)

  type 'a table = (ModuleId.modId * 'a) list

  val empty : 'a table = nil

  fun look (key,alist: 'a table) =
      let fun loop nil = NONE
	    | loop ((k,v)::rest) =
	        if ModuleId.equalId(key,k) then SOME v else loop rest
       in loop alist
      end

  fun bind (key, value, alist: 'a table) = 
      case look (key,alist) of SOME _ => alist 
                             | NONE => (key,value)::alist

  val app = List.app

end (* structure StampTable *)
