(* moduleid.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

(* moduleid.sml *)

signature MODULE_ID =
sig
  type stamp  (* = Stamps.stamp *)
  datatype modId
    = SIMPLEid of stamp                 (* SIMPLE strs *)
    | INSTANCEid of {origin: stamp, sign: stamp}       (* INSTANCE strs *)
    | SIGid of stamp                    (* structure signatures *)
    | FCTid of stamp                    (* simple functors *)
    | FCT_INSTANCEid of {fct: modId, fsig: modId}   (* instance functors *)
    | FSIGid of {argument: stamp, body: stamp}    (* functor signatures *)
    | TYCid of stamp

  val equalId : modId * modId -> bool 
end

structure ModuleId : MODULE_ID =
struct

  type stamp = Stamps.stamp

  datatype modId
    = SIMPLEid of stamp                 (* SIMPLE strs *)
    | INSTANCEid of {origin: stamp, sign: stamp}       (* INSTANCE strs *)
    | SIGid of stamp                    (* structure signatures *)
    | FCTid of stamp                    (* simple functors *)
    | FCT_INSTANCEid of {fct: modId, fsig: modId}   (* instance functors *)
    | FSIGid of {argument: stamp, body: stamp}    (* functor signatures *)
    | TYCid of stamp

  val op / = Stamps.eq

  fun equalId(SIMPLEid a,SIMPLEid b) = a/b
    | equalId(INSTANCEid{origin=a1,sign=b1},INSTANCEid{origin=a2,sign=b2}) =
           a1/a2 andalso b1/b2
    | equalId(SIGid a, SIGid b) = a/b
    | equalId(FCTid a, FCTid b) = a/b
    | equalId(FCT_INSTANCEid{fct=a1,fsig=b1},
	      FCT_INSTANCEid{fct=a2,fsig=b2}) =
             equalId(a1,a2) andalso equalId(b1,b2)
    | equalId(FSIGid{argument=a1,body=b1},FSIGid{argument=a2,body=b2}) =
           a1/a2 andalso b1/b2
    | equalId(TYCid a, TYCid b) = a/b
    | equalId _ = false    

end (* structure ModuleId *)
