(* Copyright 1989 by AT&T Bell Laboratories *)
(* environ.sig *)

signature ENVIRONMENT = sig

  type staticEnv and dynenv and symenv
  type environment
       (* = { static: staticEnv, dynamic: dynenv, symbolic: symenv } *)
  type symbol (* = Symbol.symbol *)

  val emptyEnv : environment
  val staticPart : environment -> staticEnv
  val dynamicPart : environment -> dynenv
  val symbolicPart : environment -> symenv
  val mkenv : { static: staticEnv, dynamic: dynenv, symbolic: symenv }
      -> environment

  val exports:
      staticEnv * PersStamps.persstamp ->
      staticEnv * Lambda.lexp * PersStamps.persstamp option
  (* the Lambda.lexp part of the result constructs the (single) dynamic
   * value corresponding to a compilation unit *)

  val layerEnv    : environment * environment -> environment
  val concatEnv   : environment * environment -> environment
  val layerStatic : staticEnv * staticEnv -> staticEnv
  val layerSymbolic: symenv * symenv -> symenv
  val filterEnv   : environment * Symbol.symbol list -> environment
  val filterStaticEnv : staticEnv * Symbol.symbol list -> staticEnv
  val consolidateEnv : environment -> environment
  val consolidateStatic : staticEnv -> staticEnv
  val consolidateSymbolic: symenv -> symenv

  val catalogEnv : staticEnv -> Symbol.symbol list

  (* CM-style environment lookup *)
  datatype cmEnv =
      CM_NONE
    | CM_ENV of Symbol.symbol -> cmEnv

  val cmEnvOfModule: staticEnv -> Symbol.symbol -> cmEnv

  (* for backward compatibility to SC *)
  exception EnvOfStructure
  val envOfStructure : staticEnv * Symbol.symbol -> staticEnv

  val describe   : staticEnv -> Symbol.symbol -> unit

  val coreEnvRef : {get: unit->staticEnv, set: staticEnv->unit} 
			  (* Core env *)

  val topLevelEnvRef : {get: unit->environment, set: environment->unit}
			  (* interactive top level env *)

  val pervasiveEnvRef : {get: unit->environment, set: environment->unit}
			  (* pervasive environment *)

  val primEnv : staticEnv

end (* structure Env *)
