(* Copyright 1992 by AT&T Bell Laboratories *)

signature ELABCORE =
sig
  type typeEnv
  type tyvUpdate
  val elabDB :
    StaticEnv.staticEnv * 
    (StaticEnv.staticEnv * Normalize.normMap option) * InvPath.path * 
    (Ast.region -> ErrorMsg.complainer) ->
    Types.tyvar list * Symbol.symbol * (Symbol.symbol * Ast.ty option) list *
    Ast.region 
    -> Types.datacon list * StaticEnv.staticEnv
  val elabDec : 
    StaticEnv.staticEnv (* coreEnv *) *
    (Ast.region -> ErrorMsg.complainer) * 
    (Ast.region -> string) * Ast.region -> 
    StaticEnv.staticEnv * InvPath.path * Stamps.scope -> Ast.dec
    -> Absyn.dec * StaticEnv.staticEnv * TyvarSet.tyvarset * 
       (TyvarSet.tyvarset -> unit)
  val elabType :
    (Ast.region -> ErrorMsg.complainer) -> 
    Ast.region -> typeEnv -> Ast.ty
    -> Types.ty * TyvarSet.tyvarset
  val elabTyv :
    (Ast.region -> ErrorMsg.complainer) ->
    Ast.region -> Ast.tyvar
    -> Types.tyvar
  val elabTyvList : 
    (Ast.region -> ErrorMsg.complainer) ->
    Ast.region -> Ast.tyvar list
    -> Types.tyvar list
end
