(***** debug info *****
nonterm 0 : reg
nonterm 1 : sreg
nonterm 2 : ureg
nonterm 3 : freg
nonterm 4 : alist

rule 1 : reg:	VAR	= reg_VAR (1);
rule 2 : reg:	LABEL	= reg_LABEL (1);
rule 3 : reg:	INT	= reg_INT (1);
rule 4 : sreg:	INT	= sreg_INT (1);
rule 5 : ureg:	INT	= ureg_INT (1);
rule 6 : reg:	INT32	= reg_INT32 (1);
rule 7 : reg:	REAL	= reg_REAL (4);
rule 8 : reg:	STRING	= reg_STRING (1);
rule 9 : freg:	VAR	= freg_VAR (1);
rule 10 : freg:	REAL	= freg_REAL (1);
rule 11 : freg:	reg	= freg_reg (1);
rule 12 : reg:	freg	= reg_freg (1);
rule 13 : reg:	sreg	= reg_sreg (1);
rule 14 : sreg:	reg	= sreg_reg (1);
rule 15 : sreg:	ureg	= sreg_ureg (1);
rule 16 : ureg:	sreg	= ureg_sreg_or_reg (1);
rule 17 : ureg:	reg	= ureg_sreg_or_reg (1);
rule 18 : reg:	ADD(reg,sreg)	= r_ADD_r_r (1);
rule 19 : reg:	ADD(sreg,reg)	= r_ADD_r_r (1);
rule 20 : sreg:	ADD(sreg,sreg)	= r_ADD_r_r (1);
rule 21 : sreg:	ADD(INT,reg)	= r_ADD_2im_r (2);
rule 22 : sreg:	ADD(reg,INT)	= r_ADD_r_2im (2);
rule 23 : reg:	SUB(reg,sreg)	= r_SUB_r_r (1);
rule 24 : reg:	SUB(INT,reg)	= r_SUB_2ipp_r (2);
rule 25 : reg:	SUB(sreg,INT)	= r_SUB_r_2im (2);
rule 26 : sreg:	SUB(sreg,sreg)	= r_SUB_r_r (1);
rule 27 : sreg:	SUB(reg,reg)	= r_SUB_r_r (1);
rule 28 : sreg:	MUL(sreg,ureg)	= r_MUL_r_r (1);
rule 29 : sreg:	MUL(ureg,sreg)	= r_MUL_r_r (1);
rule 30 : ureg:	DIV(sreg,sreg)	= r_DIV_r_r (1);
rule 31 : ureg:	DIV(ureg,ureg)	= r_DIV_r_r (1);
rule 32 : reg:	NEG(reg)	= r_NEG_r_p_2 (2);
rule 33 : ureg:	NEG(ureg)	= r_NEG_r (2);
rule 34 : sreg:	NEG(sreg)	= r_NEG_r (2);
rule 35 : ureg:	ORB(ureg,ureg)	= r_ORB_r_r (1);
rule 36 : reg:	ORB(reg,reg)	= r_ORB_r_r (1);
rule 37 : reg:	ORB(reg,sreg)	= r_ORB_r_r (1);
rule 38 : reg:	ORB(sreg,reg)	= r_ORB_r_r (1);
rule 39 : sreg:	ORB(sreg,sreg)	= r_ORB_r_r (1);
rule 40 : ureg:	ANDB(ureg,ureg)	= r_ANDB_r_r (1);
rule 41 : reg:	ANDB(reg,reg)	= r_ANDB_r_r (1);
rule 42 : sreg:	ANDB(sreg,sreg)	= r_ANDB_r_r (1);
rule 43 : sreg:	ANDB(reg,sreg)	= r_ANDB_r_r (1);
rule 44 : sreg:	ANDB(sreg,reg)	= r_ANDB_r_r (1);
rule 45 : ureg:	XORB(ureg,ureg)	= r_XORB_r_r (1);
rule 46 : reg:	XORB(reg,sreg)	= r_XORB_r_r (1);
rule 47 : reg:	XORB(sreg,reg)	= r_XORB_r_r (1);
rule 48 : sreg:	XORB(sreg,sreg)	= r_XORB_r_r (1);
rule 49 : sreg:	XORB(reg,reg)	= r_XORB_r_r (1);
rule 50 : ureg:	NOTB(ureg)	= r_NOTB_r (1);
rule 51 : reg:	NOTB(reg)	= r_NOTB_r_p_1 (2);
rule 52 : ureg:	RSHIFT(ureg,ureg)	= r_RSHIFT_r_r (1);
rule 53 : reg:	RSHIFT(reg,ureg)	= r_RSHIFT_r_r_o (3);
rule 54 : reg:	RSHIFT(sreg,ureg)	= r_RSHIFT_r_r_o (3);
rule 55 : sreg:	RSHIFT(reg,ureg)	= r_RSHIFT_r_r_a (3);
rule 56 : sreg:	RSHIFT(sreg,ureg)	= r_RSHIFT_r_r_a (3);
rule 57 : reg:	RSHIFTL(reg,ureg)	= r_RSHIFTL_r_u (1);
rule 58 : ureg:	LSHIFT(ureg,ureg)	= r_LSHIFT_r_r (1);
rule 59 : sreg:	LSHIFT(sreg,ureg)	= r_LSHIFT_r_r (1);
rule 60 : reg:	W32ADD(reg,reg)	= r_W32ADD_r_r (1);
rule 61 : reg:	W32SUB(reg,reg)	= r_W32SUB_r_r (1);
rule 62 : reg:	W32MUL(reg,reg)	= r_W32MUL_r_r (1);
rule 63 : reg:	W32DIV(reg,reg)	= r_W32DIV_r_r (1);
rule 64 : reg:	W32LSHIFT(reg,ureg)	= r_LSHIFT_r_r (1);
rule 65 : reg:	W32RSHIFT(reg,ureg)	= r_RSHIFT_r_r (1);
rule 66 : reg:	W32RSHIFTL(reg,ureg)	= r_RSHIFTL_r_r (1);
rule 67 : reg:	W32ANDB(reg,reg)	= r_ANDB_r_r (1);
rule 68 : reg:	W32ORB(reg,reg)	= r_ORB_r_r (1);
rule 69 : reg:	W32XORB(reg,reg)	= r_XORB_r_r (1);
rule 70 : reg:	W32NOTB(reg)	= r_NOTB_r (1);
rule 71 : reg:	W32FROMINT(ureg)	= CAST (0);
rule 72 : ureg:	W32TOINT(reg)	= CAST (0);
rule 73 : reg:	W31TOW32(ureg)	= CAST (0);
rule 74 : reg:	W31TOW32(reg)	= r_W32FROMWORD_r (1);
rule 75 : ureg:	W31FROMW32(reg)	= CAST (0);
rule 76 : reg:	W31TOINT(reg)	= CAST (0);
rule 77 : reg:	W31FROMINT(reg)	= CAST (0);
rule 78 : freg:	FADD(freg,freg)	= f_FADD_f_f (1);
rule 79 : freg:	FSUB(freg,freg)	= f_FSUB_f_f (1);
rule 80 : freg:	FMUL(freg,freg)	= f_FMUL_f_f (1);
rule 81 : freg:	FDIV(freg,freg)	= f_FDIV_f_f (1);
rule 82 : freg:	FNEG(freg)	= f_FNEG_f (1);
rule 83 : freg:	FABS(freg)	= f_FABS_f (1);
rule 84 : freg:	REALOFINT(ureg)	= f_REALOFINT_ureg (1);
rule 85 : reg:	MKSPECIAL(ureg,reg)	= reg_MKSPECIAL_ureg_reg (1);
rule 86 : ureg:	LENGTH(reg)	= ureg_LENGTH_reg (2);
rule 87 : sreg:	LENGTH(reg)	= sreg_LENGTH_reg (3);
rule 88 : reg:	LENGTH(reg)	= reg_LENGTH_reg (3);
rule 89 : ureg:	OBJLENGTH(reg)	= ureg_LENGTH_reg (2);
rule 90 : sreg:	OBJLENGTH(reg)	= sreg_LENGTH_reg (3);
rule 91 : reg:	OBJLENGTH(reg)	= reg_LENGTH_reg (3);
rule 92 : ureg:	GETTAG(reg)	= ureg_GETTAG_reg (2);
rule 93 : reg:	SUBSCRIPTV(reg,INT)	= reg_SUBSCRIPTV_reg_i (1);
rule 94 : reg:	SUBSCRIPTV(reg,ureg)	= reg_SUBSCRIPTV_reg_ureg (2);
rule 95 : reg:	SUBSCRIPTV(reg,sreg)	= reg_SUBSCRIPTV_reg_sreg (2);
rule 96 : reg:	SUBSCRIPTV(reg,reg)	= reg_SUBSCRIPTV_reg_reg (3);
rule 97 : reg:	DEREF(reg)	= reg_DEREF_reg (1);
rule 98 : reg:	SUBSCRIPT(reg,INT)	= reg_SUBSCRIPTV_reg_i (1);
rule 99 : reg:	SUBSCRIPT(reg,ureg)	= reg_SUBSCRIPTV_reg_ureg (3);
rule 100 : reg:	SUBSCRIPT(reg,sreg)	= reg_SUBSCRIPTV_reg_sreg (3);
rule 101 : reg:	SUBSCRIPT(reg,reg)	= reg_SUBSCRIPTV_reg_reg (3);
rule 102 : freg:	SUBSCRIPTF(reg,INT)	= freg_SUBSCRIPTF_reg_i (2);
rule 103 : freg:	SUBSCRIPTF(reg,ureg)	= freg_SUBSCRIPTF_reg_ureg (3);
rule 104 : freg:	SUBSCRIPTF(reg,sreg)	= freg_SUBSCRIPTF_reg_sreg (3);
rule 105 : freg:	SUBSCRIPTF(reg,reg)	= freg_SUBSCRIPTF_reg_reg (3);
rule 106 : ureg:	ORDOF(reg,ureg)	= ureg_ORDOF_reg_ureg (1);
rule 107 : ureg:	GETSPECIAL(reg)	= ureg_GETSPECIAL_reg (1);
rule 108 : reg:	GETVAR	= reg_GETVAR (1);
rule 109 : reg:	GETHDLR	= reg_GETHDLR (1);
rule 110 : reg:	RSTORE(reg)	= reg_RSTORE_reg (1);
rule 111 : reg:	RSTOREF(reg)	= reg_RSTOREF_reg (1);
rule 112 : reg:	RSTOREF0(freg)	= reg_RSTOREF0_freg (1);
rule 113 : reg:	RSTOREDESC	= reg_RSTOREDESC (1);
rule 114 : reg:	RSTORESTORE	= reg_RSTORESTORE (1);
rule 115 : reg:	RSET	= reg_RSET (1);
rule 116 : reg:	RSETSTORE	= reg_RSETSTORE (1);
rule 117 : reg:	RINC	= reg_RINC (1);
rule 118 : reg:	SELECT(reg)	= reg_SELECT_reg (1);
rule 119 : freg:	SELECTF(reg)	= freg_SELECTF_reg (1);
rule 120 : reg:	OFFSET(reg)	= reg_OFFSET_reg (1);
rule 121 : reg:	STORE(reg,ureg,ureg)	= reg_STORE_reg_ureg_ureg (1);
rule 122 : reg:	UNBOXEDUPDATE(reg,INT,reg)	= reg_UNBOXEDUPDATE_reg_i_reg (2);
rule 123 : reg:	UNBOXEDUPDATE(reg,ureg,reg)	= reg_UNBOXEDUPDATE_reg_ureg_reg (2);
rule 124 : reg:	UNBOXEDUPDATE(reg,sreg,reg)	= reg_UNBOXEDUPDATE_reg_sreg_reg (2);
rule 125 : reg:	UNBOXEDUPDATE(reg,reg,reg)	= reg_UNBOXEDUPDATE_reg_reg_reg (3);
rule 126 : reg:	CALCADDR(reg,INT)	= reg_CALCADDR_reg_i (1);
rule 127 : reg:	CALCADDR(reg,ureg)	= reg_CALCADDR_reg_ureg (2);
rule 128 : reg:	CALCADDR(reg,sreg)	= reg_CALCADDR_reg_sreg (2);
rule 129 : reg:	CALCADDR(reg,reg)	= reg_CALCADDR_reg_reg (3);
rule 130 : reg:	UPDATEF(reg,INT,freg)	= reg_UPDATEF_reg_i_freg (2);
rule 131 : reg:	UPDATEF(reg,ureg,freg)	= reg_UPDATEF_reg_ureg_freg (3);
rule 132 : reg:	UPDATEF(reg,sreg,freg)	= reg_UPDATEF_reg_sreg_freg (3);
rule 133 : reg:	UPDATEF(reg,reg,freg)	= reg_UPDATEF_reg_reg_freg (3);
rule 134 : reg:	SETHDLR(reg)	= reg_SETHDLR_reg (1);
rule 135 : reg:	SETVAR(reg)	= reg_SETVAR_reg (1);
rule 136 : reg:	SETSPECIAL(reg,ureg)	= reg_SETSPECIAL_reg_ureg (1);
rule 137 : reg:	APP_VAR(alist)	= reg_APP_VAR_alist (1);
rule 138 : reg:	APP_LABEL(alist)	= reg_APP_LABEL_alist (1);
rule 139 : alist:	ACONS(LABEL,alist)	= alist_ACONS_LABEL_alist (1);
rule 140 : alist:	ACONS(INT,alist)	= alist_ACONS_INT_alist (1);
rule 141 : alist:	ACONS(REAL,alist)	= alist_ACONS_REAL_alist (1);
rule 142 : alist:	ACONSF(REAL,alist)	= alist_ACONS_REAL_alist (1);
rule 143 : alist:	ACONS(STRING,alist)	= alist_ACONS_STRING_alist (1);
rule 144 : alist:	ACONS(reg,alist)	= alist_ACONS_reg_alist (2);
rule 145 : alist:	ACONSF(freg,alist)	= alist_ACONSF_freg_alist (1);
rule 146 : alist:	ANIL	= alist_ANIL (1);
rule 147 : reg:	SWITCH(INT)	= reg_SWITCH_i (1);
rule 148 : reg:	SWITCH(ureg)	= reg_SWITCH_ureg (1);
rule 149 : reg:	SWITCH(sreg)	= reg_SWITCH_sreg (1);
rule 150 : reg:	BR_BOXED(reg)	= reg_BR_BOXED_reg (1);
rule 151 : reg:	BR_INT(reg,reg)	= reg_BR_INT_reg_reg (1);
rule 152 : reg:	BR_WORD32(reg,reg)	= reg_BR_INT_reg_reg (1);
rule 153 : reg:	BR_FLOAT(freg,freg)	= reg_BR_FLOAT_freg_freg (1);
rule 154 : reg:	BR_STRING(INT,reg,reg)	= reg_BR_STRING_INT_reg_reg (1);
rule 155 : reg:	BR_RNGCHK(reg,reg)	= reg_BR_RNGCHK_reg_reg (1);
rule 156 : reg:	GETPSEUDO(reg)	= reg_GETPSEUDO_reg (1);
rule 157 : reg:	SETPSEUDO(reg,reg)	= reg_SETPSEUDO_reg_reg (1);
rule 158 : reg:	WRAP	= reg_dummy (0);
rule 159 : reg:	UNWRAP	= reg_dummy (0);
rule 160 : reg:	CAST	= reg_dummy (0);
**********************)


structure BurmOps = struct
  datatype ops = T_VAR
	       | T_LABEL
	       | T_INT
	       | T_INT32
	       | T_REAL
	       | T_STRING
	       | T_ADD
	       | T_SUB
	       | T_MUL
	       | T_DIV
	       | T_NEG
	       | T_FADD
	       | T_FSUB
	       | T_FMUL
	       | T_FDIV
	       | T_LENGTH
	       | T_OBJLENGTH
	       | T_RSHIFT
	       | T_RSHIFTL
	       | T_LSHIFT
	       | T_ORB
	       | T_ANDB
	       | T_XORB
	       | T_NOTB
	       | T_W32ADD
	       | T_W32SUB
	       | T_W32MUL
	       | T_W32DIV
	       | T_W32LSHIFT
	       | T_W32RSHIFT
	       | T_W32RSHIFTL
	       | T_W32ANDB
	       | T_W32ORB
	       | T_W32XORB
	       | T_W32NOTB
	       | T_W32TOINT
	       | T_W32FROMINT
	       | T_W31TOINT
	       | T_W31FROMINT
	       | T_W31FROMW32
	       | T_W31TOW32
	       | T_FNEG
	       | T_FABS
	       | T_REALOFINT
	       | T_SUBSCRIPTV
	       | T_GETTAG
	       | T_MKSPECIAL
	       | T_DEREF
	       | T_GETHDLR
	       | T_GETVAR
	       | T_SUBSCRIPT
	       | T_SUBSCRIPTF
	       | T_ORDOF
	       | T_GETSPECIAL
	       | T_RSTORE
	       | T_RSTOREF
	       | T_RSTOREF0
	       | T_RSTOREDESC
	       | T_RSTORESTORE
	       | T_RSET
	       | T_RSETSTORE
	       | T_RINC
	       | T_SELECT
	       | T_SELECTF
	       | T_OFFSET
	       | T_STORE
	       | T_UNBOXEDUPDATE
	       | T_CALCADDR
	       | T_UPDATEF
	       | T_SETHDLR
	       | T_SETVAR
	       | T_SETSPECIAL
	       | T_APP_VAR
	       | T_APP_LABEL
	       | T_ACONS
	       | T_ACONSF
	       | T_ANIL
	       | T_SWITCH
	       | T_BR_BOXED
	       | T_BR_INT
	       | T_BR_WORD32
	       | T_BR_FLOAT
	       | T_BR_STRING
	       | T_BR_RNGCHK
	       | T_GETPSEUDO
	       | T_SETPSEUDO
	       | T_WRAP
	       | T_UNWRAP
	       | T_CAST
end


signature BURM_INPUT_SPEC = sig
  type tree
  val opchildren : tree -> BurmOps.ops * (tree list)
end


signature BURM = sig
  exception NoMatch
  type tree
  datatype rule = reg_VAR
		| reg_LABEL
		| reg_INT
		| sreg_INT
		| ureg_INT
		| reg_INT32
		| reg_REAL
		| reg_STRING
		| freg_VAR
		| freg_REAL
		| freg_reg of (rule * tree)
		| reg_freg of (rule * tree)
		| reg_sreg of (rule * tree)
		| sreg_reg of (rule * tree)
		| sreg_ureg of (rule * tree)
		| ureg_sreg_or_reg of (rule * tree)
		| r_ADD_r_r of (rule * tree) * (rule * tree)
		| r_ADD_2im_r of (rule * tree)
		| r_ADD_r_2im of (rule * tree)
		| r_SUB_r_r of (rule * tree) * (rule * tree)
		| r_SUB_2ipp_r of (rule * tree)
		| r_SUB_r_2im of (rule * tree)
		| r_MUL_r_r of (rule * tree) * (rule * tree)
		| r_DIV_r_r of (rule * tree) * (rule * tree)
		| r_NEG_r_p_2 of (rule * tree)
		| r_NEG_r of (rule * tree)
		| r_ORB_r_r of (rule * tree) * (rule * tree)
		| r_ANDB_r_r of (rule * tree) * (rule * tree)
		| r_XORB_r_r of (rule * tree) * (rule * tree)
		| r_NOTB_r of (rule * tree)
		| r_NOTB_r_p_1 of (rule * tree)
		| r_RSHIFT_r_r of (rule * tree) * (rule * tree)
		| r_RSHIFT_r_r_o of (rule * tree) * (rule * tree)
		| r_RSHIFT_r_r_a of (rule * tree) * (rule * tree)
		| r_RSHIFTL_r_u of (rule * tree) * (rule * tree)
		| r_LSHIFT_r_r of (rule * tree) * (rule * tree)
		| r_W32ADD_r_r of (rule * tree) * (rule * tree)
		| r_W32SUB_r_r of (rule * tree) * (rule * tree)
		| r_W32MUL_r_r of (rule * tree) * (rule * tree)
		| r_W32DIV_r_r of (rule * tree) * (rule * tree)
		| r_RSHIFTL_r_r of (rule * tree) * (rule * tree)
		| CAST of (rule * tree)
		| r_W32FROMWORD_r of (rule * tree)
		| f_FADD_f_f of (rule * tree) * (rule * tree)
		| f_FSUB_f_f of (rule * tree) * (rule * tree)
		| f_FMUL_f_f of (rule * tree) * (rule * tree)
		| f_FDIV_f_f of (rule * tree) * (rule * tree)
		| f_FNEG_f of (rule * tree)
		| f_FABS_f of (rule * tree)
		| f_REALOFINT_ureg of (rule * tree)
		| reg_MKSPECIAL_ureg_reg of (rule * tree) * (rule * tree)
		| ureg_LENGTH_reg of (rule * tree)
		| sreg_LENGTH_reg of (rule * tree)
		| reg_LENGTH_reg of (rule * tree)
		| ureg_GETTAG_reg of (rule * tree)
		| reg_SUBSCRIPTV_reg_i of (rule * tree)
		| reg_SUBSCRIPTV_reg_ureg of (rule * tree) * (rule * tree)
		| reg_SUBSCRIPTV_reg_sreg of (rule * tree) * (rule * tree)
		| reg_SUBSCRIPTV_reg_reg of (rule * tree) * (rule * tree)
		| reg_DEREF_reg of (rule * tree)
		| freg_SUBSCRIPTF_reg_i of (rule * tree)
		| freg_SUBSCRIPTF_reg_ureg of (rule * tree) * (rule * tree)
		| freg_SUBSCRIPTF_reg_sreg of (rule * tree) * (rule * tree)
		| freg_SUBSCRIPTF_reg_reg of (rule * tree) * (rule * tree)
		| ureg_ORDOF_reg_ureg of (rule * tree) * (rule * tree)
		| ureg_GETSPECIAL_reg of (rule * tree)
		| reg_GETVAR
		| reg_GETHDLR
		| reg_RSTORE_reg of (rule * tree)
		| reg_RSTOREF_reg of (rule * tree)
		| reg_RSTOREF0_freg of (rule * tree)
		| reg_RSTOREDESC
		| reg_RSTORESTORE
		| reg_RSET
		| reg_RSETSTORE
		| reg_RINC
		| reg_SELECT_reg of (rule * tree)
		| freg_SELECTF_reg of (rule * tree)
		| reg_OFFSET_reg of (rule * tree)
		| reg_STORE_reg_ureg_ureg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_i_reg of (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_ureg_reg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_sreg_reg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_reg_reg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_CALCADDR_reg_i of (rule * tree)
		| reg_CALCADDR_reg_ureg of (rule * tree) * (rule * tree)
		| reg_CALCADDR_reg_sreg of (rule * tree) * (rule * tree)
		| reg_CALCADDR_reg_reg of (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_i_freg of (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_ureg_freg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_sreg_freg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_reg_freg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_SETHDLR_reg of (rule * tree)
		| reg_SETVAR_reg of (rule * tree)
		| reg_SETSPECIAL_reg_ureg of (rule * tree) * (rule * tree)
		| reg_APP_VAR_alist of (rule * tree)
		| reg_APP_LABEL_alist of (rule * tree)
		| alist_ACONS_LABEL_alist of (rule * tree)
		| alist_ACONS_INT_alist of (rule * tree)
		| alist_ACONS_REAL_alist of (rule * tree)
		| alist_ACONS_STRING_alist of (rule * tree)
		| alist_ACONS_reg_alist of (rule * tree) * (rule * tree)
		| alist_ACONSF_freg_alist of (rule * tree) * (rule * tree)
		| alist_ANIL
		| reg_SWITCH_i
		| reg_SWITCH_ureg of (rule * tree)
		| reg_SWITCH_sreg of (rule * tree)
		| reg_BR_BOXED_reg of (rule * tree)
		| reg_BR_INT_reg_reg of (rule * tree) * (rule * tree)
		| reg_BR_FLOAT_freg_freg of (rule * tree) * (rule * tree)
		| reg_BR_STRING_INT_reg_reg of (rule * tree) * (rule * tree)
		| reg_BR_RNGCHK_reg_reg of (rule * tree) * (rule * tree)
		| reg_GETPSEUDO_reg of (rule * tree)
		| reg_SETPSEUDO_reg_reg of (rule * tree) * (rule * tree)
		| reg_dummy
  val reduce : tree -> rule * tree
  val ruleToString : rule -> string
end


functor BurmGen (In : BURM_INPUT_SPEC) : BURM =
  struct

    type tree = In.tree

    exception NoMatch
  datatype rule = reg_VAR
		| reg_LABEL
		| reg_INT
		| sreg_INT
		| ureg_INT
		| reg_INT32
		| reg_REAL
		| reg_STRING
		| freg_VAR
		| freg_REAL
		| freg_reg of (rule * tree)
		| reg_freg of (rule * tree)
		| reg_sreg of (rule * tree)
		| sreg_reg of (rule * tree)
		| sreg_ureg of (rule * tree)
		| ureg_sreg_or_reg of (rule * tree)
		| r_ADD_r_r of (rule * tree) * (rule * tree)
		| r_ADD_2im_r of (rule * tree)
		| r_ADD_r_2im of (rule * tree)
		| r_SUB_r_r of (rule * tree) * (rule * tree)
		| r_SUB_2ipp_r of (rule * tree)
		| r_SUB_r_2im of (rule * tree)
		| r_MUL_r_r of (rule * tree) * (rule * tree)
		| r_DIV_r_r of (rule * tree) * (rule * tree)
		| r_NEG_r_p_2 of (rule * tree)
		| r_NEG_r of (rule * tree)
		| r_ORB_r_r of (rule * tree) * (rule * tree)
		| r_ANDB_r_r of (rule * tree) * (rule * tree)
		| r_XORB_r_r of (rule * tree) * (rule * tree)
		| r_NOTB_r of (rule * tree)
		| r_NOTB_r_p_1 of (rule * tree)
		| r_RSHIFT_r_r of (rule * tree) * (rule * tree)
		| r_RSHIFT_r_r_o of (rule * tree) * (rule * tree)
		| r_RSHIFT_r_r_a of (rule * tree) * (rule * tree)
		| r_RSHIFTL_r_u of (rule * tree) * (rule * tree)
		| r_LSHIFT_r_r of (rule * tree) * (rule * tree)
		| r_W32ADD_r_r of (rule * tree) * (rule * tree)
		| r_W32SUB_r_r of (rule * tree) * (rule * tree)
		| r_W32MUL_r_r of (rule * tree) * (rule * tree)
		| r_W32DIV_r_r of (rule * tree) * (rule * tree)
		| r_RSHIFTL_r_r of (rule * tree) * (rule * tree)
		| CAST of (rule * tree)
		| r_W32FROMWORD_r of (rule * tree)
		| f_FADD_f_f of (rule * tree) * (rule * tree)
		| f_FSUB_f_f of (rule * tree) * (rule * tree)
		| f_FMUL_f_f of (rule * tree) * (rule * tree)
		| f_FDIV_f_f of (rule * tree) * (rule * tree)
		| f_FNEG_f of (rule * tree)
		| f_FABS_f of (rule * tree)
		| f_REALOFINT_ureg of (rule * tree)
		| reg_MKSPECIAL_ureg_reg of (rule * tree) * (rule * tree)
		| ureg_LENGTH_reg of (rule * tree)
		| sreg_LENGTH_reg of (rule * tree)
		| reg_LENGTH_reg of (rule * tree)
		| ureg_GETTAG_reg of (rule * tree)
		| reg_SUBSCRIPTV_reg_i of (rule * tree)
		| reg_SUBSCRIPTV_reg_ureg of (rule * tree) * (rule * tree)
		| reg_SUBSCRIPTV_reg_sreg of (rule * tree) * (rule * tree)
		| reg_SUBSCRIPTV_reg_reg of (rule * tree) * (rule * tree)
		| reg_DEREF_reg of (rule * tree)
		| freg_SUBSCRIPTF_reg_i of (rule * tree)
		| freg_SUBSCRIPTF_reg_ureg of (rule * tree) * (rule * tree)
		| freg_SUBSCRIPTF_reg_sreg of (rule * tree) * (rule * tree)
		| freg_SUBSCRIPTF_reg_reg of (rule * tree) * (rule * tree)
		| ureg_ORDOF_reg_ureg of (rule * tree) * (rule * tree)
		| ureg_GETSPECIAL_reg of (rule * tree)
		| reg_GETVAR
		| reg_GETHDLR
		| reg_RSTORE_reg of (rule * tree)
		| reg_RSTOREF_reg of (rule * tree)
		| reg_RSTOREF0_freg of (rule * tree)
		| reg_RSTOREDESC
		| reg_RSTORESTORE
		| reg_RSET
		| reg_RSETSTORE
		| reg_RINC
		| reg_SELECT_reg of (rule * tree)
		| freg_SELECTF_reg of (rule * tree)
		| reg_OFFSET_reg of (rule * tree)
		| reg_STORE_reg_ureg_ureg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_i_reg of (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_ureg_reg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_sreg_reg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UNBOXEDUPDATE_reg_reg_reg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_CALCADDR_reg_i of (rule * tree)
		| reg_CALCADDR_reg_ureg of (rule * tree) * (rule * tree)
		| reg_CALCADDR_reg_sreg of (rule * tree) * (rule * tree)
		| reg_CALCADDR_reg_reg of (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_i_freg of (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_ureg_freg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_sreg_freg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_UPDATEF_reg_reg_freg of (rule * tree) * (rule * tree) * (rule * tree)
		| reg_SETHDLR_reg of (rule * tree)
		| reg_SETVAR_reg of (rule * tree)
		| reg_SETSPECIAL_reg_ureg of (rule * tree) * (rule * tree)
		| reg_APP_VAR_alist of (rule * tree)
		| reg_APP_LABEL_alist of (rule * tree)
		| alist_ACONS_LABEL_alist of (rule * tree)
		| alist_ACONS_INT_alist of (rule * tree)
		| alist_ACONS_REAL_alist of (rule * tree)
		| alist_ACONS_STRING_alist of (rule * tree)
		| alist_ACONS_reg_alist of (rule * tree) * (rule * tree)
		| alist_ACONSF_freg_alist of (rule * tree) * (rule * tree)
		| alist_ANIL
		| reg_SWITCH_i
		| reg_SWITCH_ureg of (rule * tree)
		| reg_SWITCH_sreg of (rule * tree)
		| reg_BR_BOXED_reg of (rule * tree)
		| reg_BR_INT_reg_reg of (rule * tree) * (rule * tree)
		| reg_BR_FLOAT_freg_freg of (rule * tree) * (rule * tree)
		| reg_BR_STRING_INT_reg_reg of (rule * tree) * (rule * tree)
		| reg_BR_RNGCHK_reg_reg of (rule * tree) * (rule * tree)
		| reg_GETPSEUDO_reg of (rule * tree)
		| reg_SETPSEUDO_reg_reg of (rule * tree) * (rule * tree)
		| reg_dummy


    fun ruleToString (reg_VAR) = "reg_VAR"
      | ruleToString(reg_LABEL) = "reg_LABEL"
      | ruleToString(reg_INT) = "reg_INT"
      | ruleToString(sreg_INT) = "sreg_INT"
      | ruleToString(ureg_INT) = "ureg_INT"
      | ruleToString(reg_INT32) = "reg_INT32"
      | ruleToString(reg_REAL) = "reg_REAL"
      | ruleToString(reg_STRING) = "reg_STRING"
      | ruleToString(freg_VAR) = "freg_VAR"
      | ruleToString(freg_REAL) = "freg_REAL"
      | ruleToString(freg_reg _) = "freg_reg"
      | ruleToString(reg_freg _) = "reg_freg"
      | ruleToString(reg_sreg _) = "reg_sreg"
      | ruleToString(sreg_reg _) = "sreg_reg"
      | ruleToString(sreg_ureg _) = "sreg_ureg"
      | ruleToString(ureg_sreg_or_reg _) = "ureg_sreg_or_reg"
      | ruleToString(r_ADD_r_r _) = "r_ADD_r_r"
      | ruleToString(r_ADD_2im_r _) = "r_ADD_2im_r"
      | ruleToString(r_ADD_r_2im _) = "r_ADD_r_2im"
      | ruleToString(r_SUB_r_r _) = "r_SUB_r_r"
      | ruleToString(r_SUB_2ipp_r _) = "r_SUB_2ipp_r"
      | ruleToString(r_SUB_r_2im _) = "r_SUB_r_2im"
      | ruleToString(r_MUL_r_r _) = "r_MUL_r_r"
      | ruleToString(r_DIV_r_r _) = "r_DIV_r_r"
      | ruleToString(r_NEG_r_p_2 _) = "r_NEG_r_p_2"
      | ruleToString(r_NEG_r _) = "r_NEG_r"
      | ruleToString(r_ORB_r_r _) = "r_ORB_r_r"
      | ruleToString(r_ANDB_r_r _) = "r_ANDB_r_r"
      | ruleToString(r_XORB_r_r _) = "r_XORB_r_r"
      | ruleToString(r_NOTB_r _) = "r_NOTB_r"
      | ruleToString(r_NOTB_r_p_1 _) = "r_NOTB_r_p_1"
      | ruleToString(r_RSHIFT_r_r _) = "r_RSHIFT_r_r"
      | ruleToString(r_RSHIFT_r_r_o _) = "r_RSHIFT_r_r_o"
      | ruleToString(r_RSHIFT_r_r_a _) = "r_RSHIFT_r_r_a"
      | ruleToString(r_RSHIFTL_r_u _) = "r_RSHIFTL_r_u"
      | ruleToString(r_LSHIFT_r_r _) = "r_LSHIFT_r_r"
      | ruleToString(r_W32ADD_r_r _) = "r_W32ADD_r_r"
      | ruleToString(r_W32SUB_r_r _) = "r_W32SUB_r_r"
      | ruleToString(r_W32MUL_r_r _) = "r_W32MUL_r_r"
      | ruleToString(r_W32DIV_r_r _) = "r_W32DIV_r_r"
      | ruleToString(r_RSHIFTL_r_r _) = "r_RSHIFTL_r_r"
      | ruleToString(CAST _) = "CAST"
      | ruleToString(r_W32FROMWORD_r _) = "r_W32FROMWORD_r"
      | ruleToString(f_FADD_f_f _) = "f_FADD_f_f"
      | ruleToString(f_FSUB_f_f _) = "f_FSUB_f_f"
      | ruleToString(f_FMUL_f_f _) = "f_FMUL_f_f"
      | ruleToString(f_FDIV_f_f _) = "f_FDIV_f_f"
      | ruleToString(f_FNEG_f _) = "f_FNEG_f"
      | ruleToString(f_FABS_f _) = "f_FABS_f"
      | ruleToString(f_REALOFINT_ureg _) = "f_REALOFINT_ureg"
      | ruleToString(reg_MKSPECIAL_ureg_reg _) = "reg_MKSPECIAL_ureg_reg"
      | ruleToString(ureg_LENGTH_reg _) = "ureg_LENGTH_reg"
      | ruleToString(sreg_LENGTH_reg _) = "sreg_LENGTH_reg"
      | ruleToString(reg_LENGTH_reg _) = "reg_LENGTH_reg"
      | ruleToString(ureg_GETTAG_reg _) = "ureg_GETTAG_reg"
      | ruleToString(reg_SUBSCRIPTV_reg_i _) = "reg_SUBSCRIPTV_reg_i"
      | ruleToString(reg_SUBSCRIPTV_reg_ureg _) = "reg_SUBSCRIPTV_reg_ureg"
      | ruleToString(reg_SUBSCRIPTV_reg_sreg _) = "reg_SUBSCRIPTV_reg_sreg"
      | ruleToString(reg_SUBSCRIPTV_reg_reg _) = "reg_SUBSCRIPTV_reg_reg"
      | ruleToString(reg_DEREF_reg _) = "reg_DEREF_reg"
      | ruleToString(freg_SUBSCRIPTF_reg_i _) = "freg_SUBSCRIPTF_reg_i"
      | ruleToString(freg_SUBSCRIPTF_reg_ureg _) = "freg_SUBSCRIPTF_reg_ureg"
      | ruleToString(freg_SUBSCRIPTF_reg_sreg _) = "freg_SUBSCRIPTF_reg_sreg"
      | ruleToString(freg_SUBSCRIPTF_reg_reg _) = "freg_SUBSCRIPTF_reg_reg"
      | ruleToString(ureg_ORDOF_reg_ureg _) = "ureg_ORDOF_reg_ureg"
      | ruleToString(ureg_GETSPECIAL_reg _) = "ureg_GETSPECIAL_reg"
      | ruleToString(reg_GETVAR) = "reg_GETVAR"
      | ruleToString(reg_GETHDLR) = "reg_GETHDLR"
      | ruleToString(reg_RSTORE_reg _) = "reg_RSTORE_reg"
      | ruleToString(reg_RSTOREF_reg _) = "reg_RSTOREF_reg"
      | ruleToString(reg_RSTOREF0_freg _) = "reg_RSTOREF0_freg"
      | ruleToString(reg_RSTOREDESC) = "reg_RSTOREDESC"
      | ruleToString(reg_RSTORESTORE) = "reg_RSTORESTORE"
      | ruleToString(reg_RSET) = "reg_RSET"
      | ruleToString(reg_RSETSTORE) = "reg_RSETSTORE"
      | ruleToString(reg_RINC) = "reg_RINC"
      | ruleToString(reg_SELECT_reg _) = "reg_SELECT_reg"
      | ruleToString(freg_SELECTF_reg _) = "freg_SELECTF_reg"
      | ruleToString(reg_OFFSET_reg _) = "reg_OFFSET_reg"
      | ruleToString(reg_STORE_reg_ureg_ureg _) = "reg_STORE_reg_ureg_ureg"
      | ruleToString(reg_UNBOXEDUPDATE_reg_i_reg _) = "reg_UNBOXEDUPDATE_reg_i_reg"
      | ruleToString(reg_UNBOXEDUPDATE_reg_ureg_reg _) = "reg_UNBOXEDUPDATE_reg_ureg_reg"
      | ruleToString(reg_UNBOXEDUPDATE_reg_sreg_reg _) = "reg_UNBOXEDUPDATE_reg_sreg_reg"
      | ruleToString(reg_UNBOXEDUPDATE_reg_reg_reg _) = "reg_UNBOXEDUPDATE_reg_reg_reg"
      | ruleToString(reg_CALCADDR_reg_i _) = "reg_CALCADDR_reg_i"
      | ruleToString(reg_CALCADDR_reg_ureg _) = "reg_CALCADDR_reg_ureg"
      | ruleToString(reg_CALCADDR_reg_sreg _) = "reg_CALCADDR_reg_sreg"
      | ruleToString(reg_CALCADDR_reg_reg _) = "reg_CALCADDR_reg_reg"
      | ruleToString(reg_UPDATEF_reg_i_freg _) = "reg_UPDATEF_reg_i_freg"
      | ruleToString(reg_UPDATEF_reg_ureg_freg _) = "reg_UPDATEF_reg_ureg_freg"
      | ruleToString(reg_UPDATEF_reg_sreg_freg _) = "reg_UPDATEF_reg_sreg_freg"
      | ruleToString(reg_UPDATEF_reg_reg_freg _) = "reg_UPDATEF_reg_reg_freg"
      | ruleToString(reg_SETHDLR_reg _) = "reg_SETHDLR_reg"
      | ruleToString(reg_SETVAR_reg _) = "reg_SETVAR_reg"
      | ruleToString(reg_SETSPECIAL_reg_ureg _) = "reg_SETSPECIAL_reg_ureg"
      | ruleToString(reg_APP_VAR_alist _) = "reg_APP_VAR_alist"
      | ruleToString(reg_APP_LABEL_alist _) = "reg_APP_LABEL_alist"
      | ruleToString(alist_ACONS_LABEL_alist _) = "alist_ACONS_LABEL_alist"
      | ruleToString(alist_ACONS_INT_alist _) = "alist_ACONS_INT_alist"
      | ruleToString(alist_ACONS_REAL_alist _) = "alist_ACONS_REAL_alist"
      | ruleToString(alist_ACONS_STRING_alist _) = "alist_ACONS_STRING_alist"
      | ruleToString(alist_ACONS_reg_alist _) = "alist_ACONS_reg_alist"
      | ruleToString(alist_ACONSF_freg_alist _) = "alist_ACONSF_freg_alist"
      | ruleToString(alist_ANIL) = "alist_ANIL"
      | ruleToString(reg_SWITCH_i) = "reg_SWITCH_i"
      | ruleToString(reg_SWITCH_ureg _) = "reg_SWITCH_ureg"
      | ruleToString(reg_SWITCH_sreg _) = "reg_SWITCH_sreg"
      | ruleToString(reg_BR_BOXED_reg _) = "reg_BR_BOXED_reg"
      | ruleToString(reg_BR_INT_reg_reg _) = "reg_BR_INT_reg_reg"
      | ruleToString(reg_BR_FLOAT_freg_freg _) = "reg_BR_FLOAT_freg_freg"
      | ruleToString(reg_BR_STRING_INT_reg_reg _) = "reg_BR_STRING_INT_reg_reg"
      | ruleToString(reg_BR_RNGCHK_reg_reg _) = "reg_BR_RNGCHK_reg_reg"
      | ruleToString(reg_GETPSEUDO_reg _) = "reg_GETPSEUDO_reg"
      | ruleToString(reg_SETPSEUDO_reg_reg _) = "reg_SETPSEUDO_reg_reg"
      | ruleToString(reg_dummy) = "reg_dummy"


    type s_cost = int Array.array
    type s_rule = int Array.array
    datatype s_node =
      N_VAR
    | N_LABEL
    | N_INT
    | N_INT32
    | N_REAL
    | N_STRING
    | N_ADD		of s_tree * s_tree
    | N_SUB		of s_tree * s_tree
    | N_MUL		of s_tree * s_tree
    | N_DIV		of s_tree * s_tree
    | N_NEG		of s_tree
    | N_FADD		of s_tree * s_tree
    | N_FSUB		of s_tree * s_tree
    | N_FMUL		of s_tree * s_tree
    | N_FDIV		of s_tree * s_tree
    | N_LENGTH		of s_tree
    | N_OBJLENGTH		of s_tree
    | N_RSHIFT		of s_tree * s_tree
    | N_RSHIFTL		of s_tree * s_tree
    | N_LSHIFT		of s_tree * s_tree
    | N_ORB		of s_tree * s_tree
    | N_ANDB		of s_tree * s_tree
    | N_XORB		of s_tree * s_tree
    | N_NOTB		of s_tree
    | N_W32ADD		of s_tree * s_tree
    | N_W32SUB		of s_tree * s_tree
    | N_W32MUL		of s_tree * s_tree
    | N_W32DIV		of s_tree * s_tree
    | N_W32LSHIFT		of s_tree * s_tree
    | N_W32RSHIFT		of s_tree * s_tree
    | N_W32RSHIFTL		of s_tree * s_tree
    | N_W32ANDB		of s_tree * s_tree
    | N_W32ORB		of s_tree * s_tree
    | N_W32XORB		of s_tree * s_tree
    | N_W32NOTB		of s_tree
    | N_W32TOINT		of s_tree
    | N_W32FROMINT		of s_tree
    | N_W31TOINT		of s_tree
    | N_W31FROMINT		of s_tree
    | N_W31FROMW32		of s_tree
    | N_W31TOW32		of s_tree
    | N_FNEG		of s_tree
    | N_FABS		of s_tree
    | N_REALOFINT		of s_tree
    | N_SUBSCRIPTV		of s_tree * s_tree
    | N_GETTAG		of s_tree
    | N_MKSPECIAL		of s_tree * s_tree
    | N_DEREF		of s_tree
    | N_GETHDLR
    | N_GETVAR
    | N_SUBSCRIPT		of s_tree * s_tree
    | N_SUBSCRIPTF		of s_tree * s_tree
    | N_ORDOF		of s_tree * s_tree
    | N_GETSPECIAL		of s_tree
    | N_RSTORE		of s_tree
    | N_RSTOREF		of s_tree
    | N_RSTOREF0		of s_tree
    | N_RSTOREDESC
    | N_RSTORESTORE
    | N_RSET
    | N_RSETSTORE
    | N_RINC
    | N_SELECT		of s_tree
    | N_SELECTF		of s_tree
    | N_OFFSET		of s_tree
    | N_STORE		of s_tree * s_tree * s_tree
    | N_UNBOXEDUPDATE		of s_tree * s_tree * s_tree
    | N_CALCADDR		of s_tree * s_tree
    | N_UPDATEF		of s_tree * s_tree * s_tree
    | N_SETHDLR		of s_tree
    | N_SETVAR		of s_tree
    | N_SETSPECIAL		of s_tree * s_tree
    | N_APP_VAR		of s_tree
    | N_APP_LABEL		of s_tree
    | N_ACONS		of s_tree * s_tree
    | N_ACONSF		of s_tree * s_tree
    | N_ANIL
    | N_SWITCH		of s_tree
    | N_BR_BOXED		of s_tree
    | N_BR_INT		of s_tree * s_tree
    | N_BR_WORD32		of s_tree * s_tree
    | N_BR_FLOAT		of s_tree * s_tree
    | N_BR_STRING		of s_tree * s_tree * s_tree
    | N_BR_RNGCHK		of s_tree * s_tree
    | N_GETPSEUDO		of s_tree
    | N_SETPSEUDO		of s_tree * s_tree
    | N_WRAP
    | N_UNWRAP
    | N_CAST
    withtype s_tree = s_cost * s_rule * s_node * tree


    val sub = System.Unsafe.subscript
    val update = System.Unsafe.update
    val leaf_N_VAR =
      (Array.fromList [1,2,2,1,16383],
       Array.fromList [1,14,17,9,0],
       N_VAR)
    val leaf_N_LABEL =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [2,14,17,11,0],
       N_LABEL)
    val leaf_N_INT =
      (Array.fromList [1,1,1,2,16383],
       Array.fromList [3,4,5,11,0],
       N_INT)
    val leaf_N_INT32 =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [6,14,17,11,0],
       N_INT32)
    val leaf_N_REAL =
      (Array.fromList [2,3,3,1,16383],
       Array.fromList [12,14,17,10,0],
       N_REAL)
    val leaf_N_STRING =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [8,14,17,11,0],
       N_STRING)
    val leaf_N_GETHDLR =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [109,14,17,11,0],
       N_GETHDLR)
    val leaf_N_GETVAR =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [108,14,17,11,0],
       N_GETVAR)
    val leaf_N_RSTOREDESC =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [113,14,17,11,0],
       N_RSTOREDESC)
    val leaf_N_RSTORESTORE =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [114,14,17,11,0],
       N_RSTORESTORE)
    val leaf_N_RSET =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [115,14,17,11,0],
       N_RSET)
    val leaf_N_RSETSTORE =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [116,14,17,11,0],
       N_RSETSTORE)
    val leaf_N_RINC =
      (Array.fromList [1,2,2,2,16383],
       Array.fromList [117,14,17,11,0],
       N_RINC)
    val leaf_N_ANIL =
      (Array.fromList [16383,16383,16383,16383,1],
       Array.fromList [0,0,0,0,146],
       N_ANIL)
    val cst_cost_93 = Array.fromList [1,2,2,2,16383]
    val cst_rule_93 = Array.fromList [147,14,17,11,0]
    val leaf_N_WRAP =
      (Array.fromList [0,1,1,1,16383],
       Array.fromList [158,14,17,11,0],
       N_WRAP)
    val leaf_N_UNWRAP =
      (Array.fromList [0,1,1,1,16383],
       Array.fromList [159,14,17,11,0],
       N_UNWRAP)
    val leaf_N_CAST =
      (Array.fromList [0,1,1,1,16383],
       Array.fromList [160,14,17,11,0],
       N_CAST)
    val s_c_nothing = Array.array (5,16383)
    val s_r_nothing = Array.array (5,0)


    fun rec_label (tree : In.tree) =
      let
	fun closure_reg (s_c, s_r, c) =
	  (if c + 1 < sub (s_c,2) then
	     (update (s_c,2,c + 1);
	      update (s_r,2,17);
	      closure_ureg (s_c, s_r, c + 1)
	     )
	   else
	     ();
	   if c + 1 < sub (s_c,1) then
	     (update (s_c,1,c + 1);
	      update (s_r,1,14);
	      closure_sreg (s_c, s_r, c + 1)
	     )
	   else
	     ();
	   if c + 1 < sub (s_c,3) then
	     (update (s_c,3,c + 1);
	      update (s_r,3,11);
	      closure_freg (s_c, s_r, c + 1)
	     )
	   else
	     ()
	  )
	and closure_sreg (s_c, s_r, c) =
	  (if c + 1 < sub (s_c,2) then
	     (update (s_c,2,c + 1);
	      update (s_r,2,16);
	      closure_ureg (s_c, s_r, c + 1)
	     )
	   else
	     ();
	   if c + 1 < sub (s_c,0) then
	     (update (s_c,0,c + 1);
	      update (s_r,0,13);
	      closure_reg (s_c, s_r, c + 1)
	     )
	   else
	     ()
	  )
	and closure_ureg (s_c, s_r, c) =
	  (if c + 1 < sub (s_c,1) then
	     (update (s_c,1,c + 1);
	      update (s_r,1,15);
	      closure_sreg (s_c, s_r, c + 1)
	     )
	   else
	     ()
	  )
	and closure_freg (s_c, s_r, c) =
	  (if c + 1 < sub (s_c,0) then
	     (update (s_c,0,c + 1);
	      update (s_r,0,12);
	      closure_reg (s_c, s_r, c + 1)
	     )
	   else
	     ()
	  )
	val (term, children) = In.opchildren tree
	val (s_c, s_r, t) = case term of
	  BurmOps.T_VAR =>
	    leaf_N_VAR
	| BurmOps.T_LABEL =>
	    leaf_N_LABEL
	| BurmOps.T_INT =>
	    leaf_N_INT
	| BurmOps.T_INT32 =>
	    leaf_N_INT32
	| BurmOps.T_REAL =>
	    leaf_N_REAL
	| BurmOps.T_STRING =>
	    leaf_N_STRING
	| BurmOps.T_ADD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 2 < sub (s_c,1) then
			     (update (s_c, 1, c + 2);
			      update (s_r, 1, 22);
			      closure_sreg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		case z of
		    ((_,_,N_INT,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 2 < sub (s_c,1) then
			     (update (s_c, 1, c + 2);
			      update (s_r, 1, 21);
			      closure_sreg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 20);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 19);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 18);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ADD (t0,t1)) end
	    end
	| BurmOps.T_SUB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 27);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 26);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 23);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		case z of
		    ((_,_,N_INT,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 24);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_)) =>
		      (
		       if sub (s0_r,1)<>0 then
			 let
			   val c = sub (s0_c,1)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 25);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SUB (t0,t1)) end
	    end
	| BurmOps.T_MUL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 29);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 28);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_MUL (t0,t1)) end
	    end
	| BurmOps.T_DIV =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 31);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 30);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_DIV (t0,t1)) end
	    end
	| BurmOps.T_NEG =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 then
			 let
			   val c = sub (s0_c,1)
			 in
			   if c + 2 < sub (s_c,1) then
			     (update (s_c, 1, c + 2);
			      update (s_r, 1, 34);
			      closure_sreg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 then
			 let
			   val c = sub (s0_c,2)
			 in
			   if c + 2 < sub (s_c,2) then
			     (update (s_c, 2, c + 2);
			      update (s_r, 2, 33);
			      closure_ureg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 32);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_NEG (t0)) end
	    end
	| BurmOps.T_FADD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 78);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FADD (t0,t1)) end
	    end
	| BurmOps.T_FSUB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 79);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FSUB (t0,t1)) end
	    end
	| BurmOps.T_FMUL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 80);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FMUL (t0,t1)) end
	    end
	| BurmOps.T_FDIV =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 81);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FDIV (t0,t1)) end
	    end
	| BurmOps.T_LENGTH =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 88);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   if c + 3 < sub (s_c,1) then
			     (update (s_c, 1, c + 3);
			      update (s_r, 1, 87);
			      closure_sreg (s_c, s_r, c + 3);
			     ())
			   else ();
			   if c + 2 < sub (s_c,2) then
			     (update (s_c, 2, c + 2);
			      update (s_r, 2, 86);
			      closure_ureg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_LENGTH (t0)) end
	    end
	| BurmOps.T_OBJLENGTH =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 91);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   if c + 3 < sub (s_c,1) then
			     (update (s_c, 1, c + 3);
			      update (s_r, 1, 90);
			      closure_sreg (s_c, s_r, c + 3);
			     ())
			   else ();
			   if c + 2 < sub (s_c,2) then
			     (update (s_c, 2, c + 2);
			      update (s_r, 2, 89);
			      closure_ureg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_OBJLENGTH (t0)) end
	    end
	| BurmOps.T_RSHIFT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,2)
			 in
			   if c + 3 < sub (s_c,1) then
			     (update (s_c, 1, c + 3);
			      update (s_r, 1, 56);
			      closure_sreg (s_c, s_r, c + 3);
			     ())
			   else ();
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 54);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 3 < sub (s_c,1) then
			     (update (s_c, 1, c + 3);
			      update (s_r, 1, 55);
			      closure_sreg (s_c, s_r, c + 3);
			     ())
			   else ();
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 53);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 52);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_RSHIFT (t0,t1)) end
	    end
	| BurmOps.T_RSHIFTL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 57);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_RSHIFTL (t0,t1)) end
	    end
	| BurmOps.T_LSHIFT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 59);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 58);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_LSHIFT (t0,t1)) end
	    end
	| BurmOps.T_ORB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 39);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 38);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 37);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 36);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 35);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ORB (t0,t1)) end
	    end
	| BurmOps.T_ANDB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 44);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 43);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 42);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 41);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 40);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ANDB (t0,t1)) end
	    end
	| BurmOps.T_XORB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 49);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,1) then
			     (update (s_c, 1, c + 1);
			      update (s_r, 1, 48);
			      closure_sreg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,1)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,1) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 47);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 46);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 45);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_XORB (t0,t1)) end
	    end
	| BurmOps.T_NOTB =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 51);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 then
			 let
			   val c = sub (s0_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 50);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_NOTB (t0)) end
	    end
	| BurmOps.T_W32ADD =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 60);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32ADD (t0,t1)) end
	    end
	| BurmOps.T_W32SUB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 61);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32SUB (t0,t1)) end
	    end
	| BurmOps.T_W32MUL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 62);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32MUL (t0,t1)) end
	    end
	| BurmOps.T_W32DIV =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 63);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32DIV (t0,t1)) end
	    end
	| BurmOps.T_W32LSHIFT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 64);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32LSHIFT (t0,t1)) end
	    end
	| BurmOps.T_W32RSHIFT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 65);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32RSHIFT (t0,t1)) end
	    end
	| BurmOps.T_W32RSHIFTL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 66);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32RSHIFTL (t0,t1)) end
	    end
	| BurmOps.T_W32ANDB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 67);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32ANDB (t0,t1)) end
	    end
	| BurmOps.T_W32ORB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 68);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32ORB (t0,t1)) end
	    end
	| BurmOps.T_W32XORB =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 69);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32XORB (t0,t1)) end
	    end
	| BurmOps.T_W32NOTB =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 70);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32NOTB (t0)) end
	    end
	| BurmOps.T_W32TOINT =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 0 < sub (s_c,2) then
			     (update (s_c, 2, c + 0);
			      update (s_r, 2, 72);
			      closure_ureg (s_c, s_r, c + 0);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32TOINT (t0)) end
	    end
	| BurmOps.T_W32FROMINT =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 then
			 let
			   val c = sub (s0_c,2)
			 in
			   if c + 0 < sub (s_c,0) then
			     (update (s_c, 0, c + 0);
			      update (s_r, 0, 71);
			      closure_reg (s_c, s_r, c + 0);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W32FROMINT (t0)) end
	    end
	| BurmOps.T_W31TOINT =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 0 < sub (s_c,0) then
			     (update (s_c, 0, c + 0);
			      update (s_r, 0, 76);
			      closure_reg (s_c, s_r, c + 0);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W31TOINT (t0)) end
	    end
	| BurmOps.T_W31FROMINT =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 0 < sub (s_c,0) then
			     (update (s_c, 0, c + 0);
			      update (s_r, 0, 77);
			      closure_reg (s_c, s_r, c + 0);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W31FROMINT (t0)) end
	    end
	| BurmOps.T_W31FROMW32 =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 0 < sub (s_c,2) then
			     (update (s_c, 2, c + 0);
			      update (s_r, 2, 75);
			      closure_ureg (s_c, s_r, c + 0);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W31FROMW32 (t0)) end
	    end
	| BurmOps.T_W31TOW32 =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 74);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 then
			 let
			   val c = sub (s0_c,2)
			 in
			   if c + 0 < sub (s_c,0) then
			     (update (s_c, 0, c + 0);
			      update (s_r, 0, 73);
			      closure_reg (s_c, s_r, c + 0);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_W31TOW32 (t0)) end
	    end
	| BurmOps.T_FNEG =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 82);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FNEG (t0)) end
	    end
	| BurmOps.T_FABS =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 83);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_FABS (t0)) end
	    end
	| BurmOps.T_REALOFINT =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 then
			 let
			   val c = sub (s0_c,2)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 84);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_REALOFINT (t0)) end
	    end
	| BurmOps.T_SUBSCRIPTV =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 93);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 96);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 95);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 94);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SUBSCRIPTV (t0,t1)) end
	    end
	| BurmOps.T_GETTAG =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 2 < sub (s_c,2) then
			     (update (s_c, 2, c + 2);
			      update (s_r, 2, 92);
			      closure_ureg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_GETTAG (t0)) end
	    end
	| BurmOps.T_MKSPECIAL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,2)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,2) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 85);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_MKSPECIAL (t0,t1)) end
	    end
	| BurmOps.T_DEREF =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 97);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_DEREF (t0)) end
	    end
	| BurmOps.T_GETHDLR =>
	    leaf_N_GETHDLR
	| BurmOps.T_GETVAR =>
	    leaf_N_GETVAR
	| BurmOps.T_SUBSCRIPT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 98);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 101);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 100);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 99);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SUBSCRIPT (t0,t1)) end
	    end
	| BurmOps.T_SUBSCRIPTF =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 2 < sub (s_c,3) then
			     (update (s_c, 3, c + 2);
			      update (s_r, 3, 102);
			      closure_freg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 3 < sub (s_c,3) then
			     (update (s_c, 3, c + 3);
			      update (s_r, 3, 105);
			      closure_freg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 3 < sub (s_c,3) then
			     (update (s_c, 3, c + 3);
			      update (s_r, 3, 104);
			      closure_freg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 3 < sub (s_c,3) then
			     (update (s_c, 3, c + 3);
			      update (s_r, 3, 103);
			      closure_freg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SUBSCRIPTF (t0,t1)) end
	    end
	| BurmOps.T_ORDOF =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 106);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ORDOF (t0,t1)) end
	    end
	| BurmOps.T_GETSPECIAL =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,2) then
			     (update (s_c, 2, c + 1);
			      update (s_r, 2, 107);
			      closure_ureg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_GETSPECIAL (t0)) end
	    end
	| BurmOps.T_RSTORE =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 110);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_RSTORE (t0)) end
	    end
	| BurmOps.T_RSTOREF =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 111);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_RSTOREF (t0)) end
	    end
	| BurmOps.T_RSTOREF0 =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 then
			 let
			   val c = sub (s0_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 112);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_RSTOREF0 (t0)) end
	    end
	| BurmOps.T_RSTOREDESC =>
	    leaf_N_RSTOREDESC
	| BurmOps.T_RSTORESTORE =>
	    leaf_N_RSTORESTORE
	| BurmOps.T_RSET =>
	    leaf_N_RSET
	| BurmOps.T_RSETSTORE =>
	    leaf_N_RSETSTORE
	| BurmOps.T_RINC =>
	    leaf_N_RINC
	| BurmOps.T_SELECT =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 118);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SELECT (t0)) end
	    end
	| BurmOps.T_SELECTF =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,3) then
			     (update (s_c, 3, c + 1);
			      update (s_r, 3, 119);
			      closure_freg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SELECTF (t0)) end
	    end
	| BurmOps.T_OFFSET =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 120);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_OFFSET (t0)) end
	    end
	| BurmOps.T_STORE =>
	    let
	      val [t0,t1,t2] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1,t2) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_),(s2_c,s2_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 andalso sub (s2_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2) + sub (s2_c,2)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 121);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_STORE (t0,t1,t2)) end
	    end
	| BurmOps.T_UNBOXEDUPDATE =>
	    let
	      val [t0,t1,t2] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1,t2) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_),(s2_c,s2_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 andalso sub (s2_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0) + sub (s2_c,0)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 125);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 andalso sub (s2_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1) + sub (s2_c,0)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 124);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 andalso sub (s2_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2) + sub (s2_c,0)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 123);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 122);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_UNBOXEDUPDATE (t0,t1,t2)) end
	    end
	| BurmOps.T_CALCADDR =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 126);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 129);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 128);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 127);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_CALCADDR (t0,t1)) end
	    end
	| BurmOps.T_UPDATEF =>
	    let
	      val [t0,t1,t2] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1,t2) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(_,_,N_INT,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,3)
			 in
			   if c + 2 < sub (s_c,0) then
			     (update (s_c, 0, c + 2);
			      update (s_r, 0, 130);
			      closure_reg (s_c, s_r, c + 2);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_),(s2_c,s2_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 andalso sub (s2_r,3)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0) + sub (s2_c,3)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 133);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,1)<>0 andalso sub (s2_r,3)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,1) + sub (s2_c,3)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 132);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 andalso sub (s2_r,3)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2) + sub (s2_c,3)
			 in
			   if c + 3 < sub (s_c,0) then
			     (update (s_c, 0, c + 3);
			      update (s_r, 0, 131);
			      closure_reg (s_c, s_r, c + 3);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_UPDATEF (t0,t1,t2)) end
	    end
	| BurmOps.T_SETHDLR =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 134);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SETHDLR (t0)) end
	    end
	| BurmOps.T_SETVAR =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 135);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SETVAR (t0)) end
	    end
	| BurmOps.T_SETSPECIAL =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,2)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,2)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 136);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SETSPECIAL (t0,t1)) end
	    end
	| BurmOps.T_APP_VAR =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 137);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_APP_VAR (t0)) end
	    end
	| BurmOps.T_APP_LABEL =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 138);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_APP_LABEL (t0)) end
	    end
	| BurmOps.T_ACONS =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((_,_,N_STRING,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 143);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((_,_,N_REAL,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 141);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((_,_,N_INT,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 140);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((_,_,N_LABEL,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 139);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,4)
			 in
			   if c + 2 < sub (s_c,4) then
			     (update (s_c, 4, c + 2);
			      update (s_r, 4, 144);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ACONS (t0,t1)) end
	    end
	| BurmOps.T_ACONSF =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,4)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 145);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		case z of
		    ((_,_,N_REAL,_),(s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,4)<>0 then
			 let
			   val c = sub (s0_c,4)
			 in
			   if c + 1 < sub (s_c,4) then
			     (update (s_c, 4, c + 1);
			      update (s_r, 4, 142);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_ACONSF (t0,t1)) end
	    end
	| BurmOps.T_ANIL =>
	    leaf_N_ANIL
	| BurmOps.T_SWITCH =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
	    ((_,_,N_INT,_)) =>
		      (cst_cost_93, cst_rule_93)
		  | z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,1)<>0 then
			 let
			   val c = sub (s0_c,1)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 149);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       if sub (s0_r,2)<>0 then
			 let
			   val c = sub (s0_c,2)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 148);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SWITCH (t0)) end
	    end
	| BurmOps.T_BR_BOXED =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 150);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_BR_BOXED (t0)) end
	    end
	| BurmOps.T_BR_INT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 151);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_BR_INT (t0,t1)) end
	    end
	| BurmOps.T_BR_WORD32 =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 152);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_BR_WORD32 (t0,t1)) end
	    end
	| BurmOps.T_BR_FLOAT =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,3)<>0 andalso sub (s1_r,3)<>0 then
			 let
			   val c = sub (s0_c,3) + sub (s1_c,3)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 153);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_BR_FLOAT (t0,t1)) end
	    end
	| BurmOps.T_BR_STRING =>
	    let
	      val [t0,t1,t2] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1,t2) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((_,_,N_INT,_),(s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 154);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  | _ => ()
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_BR_STRING (t0,t1,t2)) end
	    end
	| BurmOps.T_BR_RNGCHK =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 155);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_BR_RNGCHK (t0,t1)) end
	    end
	| BurmOps.T_GETPSEUDO =>
	    let
	      val [t0] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 then
			 let
			   val c = sub (s0_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 156);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_GETPSEUDO (t0)) end
	    end
	| BurmOps.T_SETPSEUDO =>
	    let
	      val [t0,t1] = map rec_label children
	    in
	      let val (s_c, s_r) = case (t0,t1) of
		    z =>
		let
		  val s_c = Array.array (5,16383)
		  val s_r = Array.array (5,0)
		in
		case z of
		    ((s0_c,s0_r,_,_),(s1_c,s1_r,_,_)) =>
		      (
		       if sub (s0_r,0)<>0 andalso sub (s1_r,0)<>0 then
			 let
			   val c = sub (s0_c,0) + sub (s1_c,0)
			 in
			   if c + 1 < sub (s_c,0) then
			     (update (s_c, 0, c + 1);
			      update (s_r, 0, 157);
			      closure_reg (s_c, s_r, c + 1);
			     ())
			   else ();
			   ()
			 end
		       else ();
		       ()
		      )
		  ;
		  (s_c, s_r)
		end
	      in (s_c, s_r, N_SETPSEUDO (t0,t1)) end
	    end
	| BurmOps.T_WRAP =>
	    leaf_N_WRAP
	| BurmOps.T_UNWRAP =>
	    leaf_N_UNWRAP
	| BurmOps.T_CAST =>
	    leaf_N_CAST
      in
        (s_c, s_r, t, tree)
      end

    fun doreduce (stree : s_tree, nt) =
      let
	val (s_c, s_r, _, tree) = stree
	val cost = sub (s_c, nt)
      in
	if cost=16383 then
	  (print ("No Match on nonterminal "^(makestring nt)^"\n");
	   print "Possibilities were :\n";
	   let
	     fun loop n =
	       let
	         val c = Array.sub (s_c, n);
	         val r = Array.sub (s_r, n);
	       in
	         if c=16383 then () else
	           print ("rule "^(makestring r)^" with cost "
	                  ^(makestring c)^"\n");
	         loop (n+1)
	       end
	   in
	     (loop 0) handle General.Subscript => ()
	   end;
	   raise NoMatch)
	else
	  let
	    val rulensons =
	      case (sub (s_r, nt), stree) of
		(1, (_,_,N_VAR,_)) =>
		  (reg_VAR)
	      | (2, (_,_,N_LABEL,_)) =>
		  (reg_LABEL)
	      | (3, (_,_,N_INT,_)) =>
		  (reg_INT)
	      | (4, (_,_,N_INT,_)) =>
		  (sreg_INT)
	      | (5, (_,_,N_INT,_)) =>
		  (ureg_INT)
	      | (6, (_,_,N_INT32,_)) =>
		  (reg_INT32)
	      | (7, (_,_,N_REAL,_)) =>
		  (reg_REAL)
	      | (8, (_,_,N_STRING,_)) =>
		  (reg_STRING)
	      | (9, (_,_,N_VAR,_)) =>
		  (freg_VAR)
	      | (10, (_,_,N_REAL,_)) =>
		  (freg_REAL)
	      | (11, t0) =>
		  (freg_reg (doreduce (t0,0)))
	      | (12, t0) =>
		  (reg_freg (doreduce (t0,3)))
	      | (13, t0) =>
		  (reg_sreg (doreduce (t0,1)))
	      | (14, t0) =>
		  (sreg_reg (doreduce (t0,0)))
	      | (15, t0) =>
		  (sreg_ureg (doreduce (t0,2)))
	      | (16, t0) =>
		  (ureg_sreg_or_reg (doreduce (t0,1)))
	      | (17, t0) =>
		  (ureg_sreg_or_reg (doreduce (t0,0)))
	      | (18, (_,_,N_ADD (t0,t1),_)) =>
		  (r_ADD_r_r (doreduce (t0,0), doreduce (t1,1)))
	      | (19, (_,_,N_ADD (t0,t1),_)) =>
		  (r_ADD_r_r (doreduce (t0,1), doreduce (t1,0)))
	      | (20, (_,_,N_ADD (t0,t1),_)) =>
		  (r_ADD_r_r (doreduce (t0,1), doreduce (t1,1)))
	      | (21, (_,_,N_ADD ((_,_,N_INT,_),t0),_)) =>
		  (r_ADD_2im_r (doreduce (t0,0)))
	      | (22, (_,_,N_ADD (t0,(_,_,N_INT,_)),_)) =>
		  (r_ADD_r_2im (doreduce (t0,0)))
	      | (23, (_,_,N_SUB (t0,t1),_)) =>
		  (r_SUB_r_r (doreduce (t0,0), doreduce (t1,1)))
	      | (24, (_,_,N_SUB ((_,_,N_INT,_),t0),_)) =>
		  (r_SUB_2ipp_r (doreduce (t0,0)))
	      | (25, (_,_,N_SUB (t0,(_,_,N_INT,_)),_)) =>
		  (r_SUB_r_2im (doreduce (t0,1)))
	      | (26, (_,_,N_SUB (t0,t1),_)) =>
		  (r_SUB_r_r (doreduce (t0,1), doreduce (t1,1)))
	      | (27, (_,_,N_SUB (t0,t1),_)) =>
		  (r_SUB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (28, (_,_,N_MUL (t0,t1),_)) =>
		  (r_MUL_r_r (doreduce (t0,1), doreduce (t1,2)))
	      | (29, (_,_,N_MUL (t0,t1),_)) =>
		  (r_MUL_r_r (doreduce (t0,2), doreduce (t1,1)))
	      | (30, (_,_,N_DIV (t0,t1),_)) =>
		  (r_DIV_r_r (doreduce (t0,1), doreduce (t1,1)))
	      | (31, (_,_,N_DIV (t0,t1),_)) =>
		  (r_DIV_r_r (doreduce (t0,2), doreduce (t1,2)))
	      | (32, (_,_,N_NEG t0,_)) =>
		  (r_NEG_r_p_2 (doreduce (t0,0)))
	      | (33, (_,_,N_NEG t0,_)) =>
		  (r_NEG_r (doreduce (t0,2)))
	      | (34, (_,_,N_NEG t0,_)) =>
		  (r_NEG_r (doreduce (t0,1)))
	      | (35, (_,_,N_ORB (t0,t1),_)) =>
		  (r_ORB_r_r (doreduce (t0,2), doreduce (t1,2)))
	      | (36, (_,_,N_ORB (t0,t1),_)) =>
		  (r_ORB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (37, (_,_,N_ORB (t0,t1),_)) =>
		  (r_ORB_r_r (doreduce (t0,0), doreduce (t1,1)))
	      | (38, (_,_,N_ORB (t0,t1),_)) =>
		  (r_ORB_r_r (doreduce (t0,1), doreduce (t1,0)))
	      | (39, (_,_,N_ORB (t0,t1),_)) =>
		  (r_ORB_r_r (doreduce (t0,1), doreduce (t1,1)))
	      | (40, (_,_,N_ANDB (t0,t1),_)) =>
		  (r_ANDB_r_r (doreduce (t0,2), doreduce (t1,2)))
	      | (41, (_,_,N_ANDB (t0,t1),_)) =>
		  (r_ANDB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (42, (_,_,N_ANDB (t0,t1),_)) =>
		  (r_ANDB_r_r (doreduce (t0,1), doreduce (t1,1)))
	      | (43, (_,_,N_ANDB (t0,t1),_)) =>
		  (r_ANDB_r_r (doreduce (t0,0), doreduce (t1,1)))
	      | (44, (_,_,N_ANDB (t0,t1),_)) =>
		  (r_ANDB_r_r (doreduce (t0,1), doreduce (t1,0)))
	      | (45, (_,_,N_XORB (t0,t1),_)) =>
		  (r_XORB_r_r (doreduce (t0,2), doreduce (t1,2)))
	      | (46, (_,_,N_XORB (t0,t1),_)) =>
		  (r_XORB_r_r (doreduce (t0,0), doreduce (t1,1)))
	      | (47, (_,_,N_XORB (t0,t1),_)) =>
		  (r_XORB_r_r (doreduce (t0,1), doreduce (t1,0)))
	      | (48, (_,_,N_XORB (t0,t1),_)) =>
		  (r_XORB_r_r (doreduce (t0,1), doreduce (t1,1)))
	      | (49, (_,_,N_XORB (t0,t1),_)) =>
		  (r_XORB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (50, (_,_,N_NOTB t0,_)) =>
		  (r_NOTB_r (doreduce (t0,2)))
	      | (51, (_,_,N_NOTB t0,_)) =>
		  (r_NOTB_r_p_1 (doreduce (t0,0)))
	      | (52, (_,_,N_RSHIFT (t0,t1),_)) =>
		  (r_RSHIFT_r_r (doreduce (t0,2), doreduce (t1,2)))
	      | (53, (_,_,N_RSHIFT (t0,t1),_)) =>
		  (r_RSHIFT_r_r_o (doreduce (t0,0), doreduce (t1,2)))
	      | (54, (_,_,N_RSHIFT (t0,t1),_)) =>
		  (r_RSHIFT_r_r_o (doreduce (t0,1), doreduce (t1,2)))
	      | (55, (_,_,N_RSHIFT (t0,t1),_)) =>
		  (r_RSHIFT_r_r_a (doreduce (t0,0), doreduce (t1,2)))
	      | (56, (_,_,N_RSHIFT (t0,t1),_)) =>
		  (r_RSHIFT_r_r_a (doreduce (t0,1), doreduce (t1,2)))
	      | (57, (_,_,N_RSHIFTL (t0,t1),_)) =>
		  (r_RSHIFTL_r_u (doreduce (t0,0), doreduce (t1,2)))
	      | (58, (_,_,N_LSHIFT (t0,t1),_)) =>
		  (r_LSHIFT_r_r (doreduce (t0,2), doreduce (t1,2)))
	      | (59, (_,_,N_LSHIFT (t0,t1),_)) =>
		  (r_LSHIFT_r_r (doreduce (t0,1), doreduce (t1,2)))
	      | (60, (_,_,N_W32ADD (t0,t1),_)) =>
		  (r_W32ADD_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (61, (_,_,N_W32SUB (t0,t1),_)) =>
		  (r_W32SUB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (62, (_,_,N_W32MUL (t0,t1),_)) =>
		  (r_W32MUL_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (63, (_,_,N_W32DIV (t0,t1),_)) =>
		  (r_W32DIV_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (64, (_,_,N_W32LSHIFT (t0,t1),_)) =>
		  (r_LSHIFT_r_r (doreduce (t0,0), doreduce (t1,2)))
	      | (65, (_,_,N_W32RSHIFT (t0,t1),_)) =>
		  (r_RSHIFT_r_r (doreduce (t0,0), doreduce (t1,2)))
	      | (66, (_,_,N_W32RSHIFTL (t0,t1),_)) =>
		  (r_RSHIFTL_r_r (doreduce (t0,0), doreduce (t1,2)))
	      | (67, (_,_,N_W32ANDB (t0,t1),_)) =>
		  (r_ANDB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (68, (_,_,N_W32ORB (t0,t1),_)) =>
		  (r_ORB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (69, (_,_,N_W32XORB (t0,t1),_)) =>
		  (r_XORB_r_r (doreduce (t0,0), doreduce (t1,0)))
	      | (70, (_,_,N_W32NOTB t0,_)) =>
		  (r_NOTB_r (doreduce (t0,0)))
	      | (71, (_,_,N_W32FROMINT t0,_)) =>
		  (CAST (doreduce (t0,2)))
	      | (72, (_,_,N_W32TOINT t0,_)) =>
		  (CAST (doreduce (t0,0)))
	      | (73, (_,_,N_W31TOW32 t0,_)) =>
		  (CAST (doreduce (t0,2)))
	      | (74, (_,_,N_W31TOW32 t0,_)) =>
		  (r_W32FROMWORD_r (doreduce (t0,0)))
	      | (75, (_,_,N_W31FROMW32 t0,_)) =>
		  (CAST (doreduce (t0,0)))
	      | (76, (_,_,N_W31TOINT t0,_)) =>
		  (CAST (doreduce (t0,0)))
	      | (77, (_,_,N_W31FROMINT t0,_)) =>
		  (CAST (doreduce (t0,0)))
	      | (78, (_,_,N_FADD (t0,t1),_)) =>
		  (f_FADD_f_f (doreduce (t0,3), doreduce (t1,3)))
	      | (79, (_,_,N_FSUB (t0,t1),_)) =>
		  (f_FSUB_f_f (doreduce (t0,3), doreduce (t1,3)))
	      | (80, (_,_,N_FMUL (t0,t1),_)) =>
		  (f_FMUL_f_f (doreduce (t0,3), doreduce (t1,3)))
	      | (81, (_,_,N_FDIV (t0,t1),_)) =>
		  (f_FDIV_f_f (doreduce (t0,3), doreduce (t1,3)))
	      | (82, (_,_,N_FNEG t0,_)) =>
		  (f_FNEG_f (doreduce (t0,3)))
	      | (83, (_,_,N_FABS t0,_)) =>
		  (f_FABS_f (doreduce (t0,3)))
	      | (84, (_,_,N_REALOFINT t0,_)) =>
		  (f_REALOFINT_ureg (doreduce (t0,2)))
	      | (85, (_,_,N_MKSPECIAL (t0,t1),_)) =>
		  (reg_MKSPECIAL_ureg_reg (doreduce (t0,2), doreduce (t1,0)))
	      | (86, (_,_,N_LENGTH t0,_)) =>
		  (ureg_LENGTH_reg (doreduce (t0,0)))
	      | (87, (_,_,N_LENGTH t0,_)) =>
		  (sreg_LENGTH_reg (doreduce (t0,0)))
	      | (88, (_,_,N_LENGTH t0,_)) =>
		  (reg_LENGTH_reg (doreduce (t0,0)))
	      | (89, (_,_,N_OBJLENGTH t0,_)) =>
		  (ureg_LENGTH_reg (doreduce (t0,0)))
	      | (90, (_,_,N_OBJLENGTH t0,_)) =>
		  (sreg_LENGTH_reg (doreduce (t0,0)))
	      | (91, (_,_,N_OBJLENGTH t0,_)) =>
		  (reg_LENGTH_reg (doreduce (t0,0)))
	      | (92, (_,_,N_GETTAG t0,_)) =>
		  (ureg_GETTAG_reg (doreduce (t0,0)))
	      | (93, (_,_,N_SUBSCRIPTV (t0,(_,_,N_INT,_)),_)) =>
		  (reg_SUBSCRIPTV_reg_i (doreduce (t0,0)))
	      | (94, (_,_,N_SUBSCRIPTV (t0,t1),_)) =>
		  (reg_SUBSCRIPTV_reg_ureg (doreduce (t0,0), doreduce (t1,2)))
	      | (95, (_,_,N_SUBSCRIPTV (t0,t1),_)) =>
		  (reg_SUBSCRIPTV_reg_sreg (doreduce (t0,0), doreduce (t1,1)))
	      | (96, (_,_,N_SUBSCRIPTV (t0,t1),_)) =>
		  (reg_SUBSCRIPTV_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (97, (_,_,N_DEREF t0,_)) =>
		  (reg_DEREF_reg (doreduce (t0,0)))
	      | (98, (_,_,N_SUBSCRIPT (t0,(_,_,N_INT,_)),_)) =>
		  (reg_SUBSCRIPTV_reg_i (doreduce (t0,0)))
	      | (99, (_,_,N_SUBSCRIPT (t0,t1),_)) =>
		  (reg_SUBSCRIPTV_reg_ureg (doreduce (t0,0), doreduce (t1,2)))
	      | (100, (_,_,N_SUBSCRIPT (t0,t1),_)) =>
		  (reg_SUBSCRIPTV_reg_sreg (doreduce (t0,0), doreduce (t1,1)))
	      | (101, (_,_,N_SUBSCRIPT (t0,t1),_)) =>
		  (reg_SUBSCRIPTV_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (102, (_,_,N_SUBSCRIPTF (t0,(_,_,N_INT,_)),_)) =>
		  (freg_SUBSCRIPTF_reg_i (doreduce (t0,0)))
	      | (103, (_,_,N_SUBSCRIPTF (t0,t1),_)) =>
		  (freg_SUBSCRIPTF_reg_ureg (doreduce (t0,0), doreduce (t1,2)))
	      | (104, (_,_,N_SUBSCRIPTF (t0,t1),_)) =>
		  (freg_SUBSCRIPTF_reg_sreg (doreduce (t0,0), doreduce (t1,1)))
	      | (105, (_,_,N_SUBSCRIPTF (t0,t1),_)) =>
		  (freg_SUBSCRIPTF_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (106, (_,_,N_ORDOF (t0,t1),_)) =>
		  (ureg_ORDOF_reg_ureg (doreduce (t0,0), doreduce (t1,2)))
	      | (107, (_,_,N_GETSPECIAL t0,_)) =>
		  (ureg_GETSPECIAL_reg (doreduce (t0,0)))
	      | (108, (_,_,N_GETVAR,_)) =>
		  (reg_GETVAR)
	      | (109, (_,_,N_GETHDLR,_)) =>
		  (reg_GETHDLR)
	      | (110, (_,_,N_RSTORE t0,_)) =>
		  (reg_RSTORE_reg (doreduce (t0,0)))
	      | (111, (_,_,N_RSTOREF t0,_)) =>
		  (reg_RSTOREF_reg (doreduce (t0,0)))
	      | (112, (_,_,N_RSTOREF0 t0,_)) =>
		  (reg_RSTOREF0_freg (doreduce (t0,3)))
	      | (113, (_,_,N_RSTOREDESC,_)) =>
		  (reg_RSTOREDESC)
	      | (114, (_,_,N_RSTORESTORE,_)) =>
		  (reg_RSTORESTORE)
	      | (115, (_,_,N_RSET,_)) =>
		  (reg_RSET)
	      | (116, (_,_,N_RSETSTORE,_)) =>
		  (reg_RSETSTORE)
	      | (117, (_,_,N_RINC,_)) =>
		  (reg_RINC)
	      | (118, (_,_,N_SELECT t0,_)) =>
		  (reg_SELECT_reg (doreduce (t0,0)))
	      | (119, (_,_,N_SELECTF t0,_)) =>
		  (freg_SELECTF_reg (doreduce (t0,0)))
	      | (120, (_,_,N_OFFSET t0,_)) =>
		  (reg_OFFSET_reg (doreduce (t0,0)))
	      | (121, (_,_,N_STORE (t0,t1,t2),_)) =>
		  (reg_STORE_reg_ureg_ureg (doreduce (t0,0), doreduce (t1,2), doreduce (t2,2)))
	      | (122, (_,_,N_UNBOXEDUPDATE (t0,(_,_,N_INT,_),t1),_)) =>
		  (reg_UNBOXEDUPDATE_reg_i_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (123, (_,_,N_UNBOXEDUPDATE (t0,t1,t2),_)) =>
		  (reg_UNBOXEDUPDATE_reg_ureg_reg (doreduce (t0,0), doreduce (t1,2), doreduce (t2,0)))
	      | (124, (_,_,N_UNBOXEDUPDATE (t0,t1,t2),_)) =>
		  (reg_UNBOXEDUPDATE_reg_sreg_reg (doreduce (t0,0), doreduce (t1,1), doreduce (t2,0)))
	      | (125, (_,_,N_UNBOXEDUPDATE (t0,t1,t2),_)) =>
		  (reg_UNBOXEDUPDATE_reg_reg_reg (doreduce (t0,0), doreduce (t1,0), doreduce (t2,0)))
	      | (126, (_,_,N_CALCADDR (t0,(_,_,N_INT,_)),_)) =>
		  (reg_CALCADDR_reg_i (doreduce (t0,0)))
	      | (127, (_,_,N_CALCADDR (t0,t1),_)) =>
		  (reg_CALCADDR_reg_ureg (doreduce (t0,0), doreduce (t1,2)))
	      | (128, (_,_,N_CALCADDR (t0,t1),_)) =>
		  (reg_CALCADDR_reg_sreg (doreduce (t0,0), doreduce (t1,1)))
	      | (129, (_,_,N_CALCADDR (t0,t1),_)) =>
		  (reg_CALCADDR_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (130, (_,_,N_UPDATEF (t0,(_,_,N_INT,_),t1),_)) =>
		  (reg_UPDATEF_reg_i_freg (doreduce (t0,0), doreduce (t1,3)))
	      | (131, (_,_,N_UPDATEF (t0,t1,t2),_)) =>
		  (reg_UPDATEF_reg_ureg_freg (doreduce (t0,0), doreduce (t1,2), doreduce (t2,3)))
	      | (132, (_,_,N_UPDATEF (t0,t1,t2),_)) =>
		  (reg_UPDATEF_reg_sreg_freg (doreduce (t0,0), doreduce (t1,1), doreduce (t2,3)))
	      | (133, (_,_,N_UPDATEF (t0,t1,t2),_)) =>
		  (reg_UPDATEF_reg_reg_freg (doreduce (t0,0), doreduce (t1,0), doreduce (t2,3)))
	      | (134, (_,_,N_SETHDLR t0,_)) =>
		  (reg_SETHDLR_reg (doreduce (t0,0)))
	      | (135, (_,_,N_SETVAR t0,_)) =>
		  (reg_SETVAR_reg (doreduce (t0,0)))
	      | (136, (_,_,N_SETSPECIAL (t0,t1),_)) =>
		  (reg_SETSPECIAL_reg_ureg (doreduce (t0,0), doreduce (t1,2)))
	      | (137, (_,_,N_APP_VAR t0,_)) =>
		  (reg_APP_VAR_alist (doreduce (t0,4)))
	      | (138, (_,_,N_APP_LABEL t0,_)) =>
		  (reg_APP_LABEL_alist (doreduce (t0,4)))
	      | (139, (_,_,N_ACONS ((_,_,N_LABEL,_),t0),_)) =>
		  (alist_ACONS_LABEL_alist (doreduce (t0,4)))
	      | (140, (_,_,N_ACONS ((_,_,N_INT,_),t0),_)) =>
		  (alist_ACONS_INT_alist (doreduce (t0,4)))
	      | (141, (_,_,N_ACONS ((_,_,N_REAL,_),t0),_)) =>
		  (alist_ACONS_REAL_alist (doreduce (t0,4)))
	      | (142, (_,_,N_ACONSF ((_,_,N_REAL,_),t0),_)) =>
		  (alist_ACONS_REAL_alist (doreduce (t0,4)))
	      | (143, (_,_,N_ACONS ((_,_,N_STRING,_),t0),_)) =>
		  (alist_ACONS_STRING_alist (doreduce (t0,4)))
	      | (144, (_,_,N_ACONS (t0,t1),_)) =>
		  (alist_ACONS_reg_alist (doreduce (t0,0), doreduce (t1,4)))
	      | (145, (_,_,N_ACONSF (t0,t1),_)) =>
		  (alist_ACONSF_freg_alist (doreduce (t0,3), doreduce (t1,4)))
	      | (146, (_,_,N_ANIL,_)) =>
		  (alist_ANIL)
	      | (147, (_,_,N_SWITCH (_,_,N_INT,_),_)) =>
		  (reg_SWITCH_i)
	      | (148, (_,_,N_SWITCH t0,_)) =>
		  (reg_SWITCH_ureg (doreduce (t0,2)))
	      | (149, (_,_,N_SWITCH t0,_)) =>
		  (reg_SWITCH_sreg (doreduce (t0,1)))
	      | (150, (_,_,N_BR_BOXED t0,_)) =>
		  (reg_BR_BOXED_reg (doreduce (t0,0)))
	      | (151, (_,_,N_BR_INT (t0,t1),_)) =>
		  (reg_BR_INT_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (152, (_,_,N_BR_WORD32 (t0,t1),_)) =>
		  (reg_BR_INT_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (153, (_,_,N_BR_FLOAT (t0,t1),_)) =>
		  (reg_BR_FLOAT_freg_freg (doreduce (t0,3), doreduce (t1,3)))
	      | (154, (_,_,N_BR_STRING ((_,_,N_INT,_),t0,t1),_)) =>
		  (reg_BR_STRING_INT_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (155, (_,_,N_BR_RNGCHK (t0,t1),_)) =>
		  (reg_BR_RNGCHK_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (156, (_,_,N_GETPSEUDO t0,_)) =>
		  (reg_GETPSEUDO_reg (doreduce (t0,0)))
	      | (157, (_,_,N_SETPSEUDO (t0,t1),_)) =>
		  (reg_SETPSEUDO_reg_reg (doreduce (t0,0), doreduce (t1,0)))
	      | (158, (_,_,N_WRAP,_)) =>
		  (reg_dummy)
	      | (159, (_,_,N_UNWRAP,_)) =>
		  (reg_dummy)
	      | (160, (_,_,N_CAST,_)) =>
		  (reg_dummy)
	      | _ => raise NoMatch (* bug in iburg *)
	  in
	    (rulensons, tree)
	  end
      end

    fun reduce (tree) =
      doreduce (rec_label (tree), 0)
  end






