(*  ctreeIn.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure CTreeIn = struct

  open BurmOps
  open CTree
    
  type tree = CTree.ctree

  fun opchildren (EX (base,children,_)) =
    let
      val t =
	case base 
	 of VAR _ 		=> T_VAR
	  | LABEL _ 		=> T_LABEL
	  | INT _ 		=> T_INT
	  | INT32 _ 		=> T_INT32
	  | REAL _ 		=> T_REAL
	  | STRING _ 		=> T_STRING
	  (* arith *)
	  | ADD _		=> T_ADD
	  | SUB _		=> T_SUB
	  | MUL _		=> T_MUL
	  | DIV _		=> T_DIV
	  | NEG 		=> T_NEG
	  | FADD 		=> T_FADD
	  | FSUB 		=> T_FSUB
	  | FMUL 		=> T_FMUL
	  | FDIV 		=> T_FDIV
	  (* pure *)
	  | LENGTH 		=> T_LENGTH
	  | OBJLENGTH 		=> T_OBJLENGTH
	  | RSHIFT 		=> T_RSHIFT
	  | RSHIFTL 		=> T_RSHIFTL
	  | LSHIFT 		=> T_LSHIFT
	  | ORB 		=> T_ORB
	  | ANDB 		=> T_ANDB
	  | XORB 		=> T_XORB
	  | NOTB 		=> T_NOTB
	  | W32ADD 		=> T_W32ADD
	  | W32SUB 		=> T_W32SUB
	  | W32MUL 		=> T_W32MUL
	  | W32DIV 		=> T_W32DIV
	  | W32RSHIFT 		=> T_W32RSHIFT
	  | W32RSHIFTL 		=> T_W32RSHIFTL
	  | W32LSHIFT 		=> T_W32LSHIFT
	  | W32ANDB 		=> T_W32ANDB
	  | W32ORB 		=> T_W32ORB
	  | W32XORB 		=> T_W32XORB
	  | W32NOTB 		=> T_W32NOTB
	  | W32TOINT 		=> T_W32TOINT
	  | W32FROMINT 		=> T_W32FROMINT
	  | W31TOINT 		=> T_W31TOINT
	  | W31FROMINT		=> T_W31FROMINT
	  | W31FROMW32		=> T_W31FROMW32
	  | W31TOW32		=> T_W31TOW32
	  | FNEG 		=> T_FNEG
	  | FABS 		=> T_FABS
	  | REALOFINT 		=> T_REALOFINT
	  | SUBSCRIPTV 		=> T_SUBSCRIPTV
	  | GETTAG 		=> T_GETTAG
	  | MKSPECIAL 		=> T_MKSPECIAL
	  (* looker *)
	  | DEREF 		=> T_DEREF
	  | GETHDLR 		=> T_GETHDLR
	  | GETVAR 		=> T_GETVAR
	  | SUBSCRIPT 		=> T_SUBSCRIPT
	  | SUBSCRIPTF 		=> T_SUBSCRIPTF
	  | ORDOF 		=> T_ORDOF
	  | GETSPECIAL 		=> T_GETSPECIAL
	  (* record *)
	  | RSTORE _ 		=> T_RSTORE
	  | RSTOREF _  		=> T_RSTOREF
	  | RSTOREF0 _ 		=> T_RSTOREF0
	  | RSTOREDESC _	=> T_RSTOREDESC
	  | RSTORESTORE _	=> T_RSTORESTORE
	  | RSET _ 		=> T_RSET
	  | RSETSTORE _ 	=> T_RSETSTORE
	  | RINC _ 		=> T_RINC
	  | SELECT _ 		=> T_SELECT
	  | SELECTF _ 		=> T_SELECTF
	  | OFFSET _ 		=> T_OFFSET
	  (* side effect operations *)
	  | STORE 		=> T_STORE
	  | UNBOXEDUPDATE 	=> T_UNBOXEDUPDATE
	  | CALCADDR 		=> T_CALCADDR
	  | UPDATEF 		=> T_UPDATEF
	  | SETHDLR 		=> T_SETHDLR
	  | SETVAR 		=> T_SETVAR
	  | SETPSEUDO 		=> T_SETPSEUDO
	  | SETSPECIAL 		=> T_SETSPECIAL
	  (* flow control primitives *)
	  | APP_VAR _ 		=> T_APP_VAR
	  | APP_LABEL _ 	=> T_APP_LABEL
	  | ACONS 		=> T_ACONS
	  | ACONSF 		=> T_ACONSF
	  | ANIL 		=> T_ANIL
	  | SWITCH _ 		=> T_SWITCH
	  | BR_BOXED _ 		=> T_BR_BOXED
	  | BR_INT _ 		=> T_BR_INT
	  | BR_WORD32 _ 	=> T_BR_WORD32
	  | BR_FLOAT _ 		=> T_BR_FLOAT
	  | BR_STRING _ 	=> T_BR_STRING

	  | GETPSEUDO   	=> T_GETPSEUDO
	  | WRAP		=> T_WRAP
	  | UNWRAP		=> T_UNWRAP
	  | CAST 		=> T_CAST
    in
      (t, children)
    end

end (* structure CTreeIn *)


