(* Copyright 1989 by AT&T Bell Laboratories *) 
(* cpscomp.sml *)

signature CPSCOMP = 
  sig val compile : Lambda.lexp * System.Unsafe.object option 
                    * ErrorMsg.complainer -> unit 
  end


functor CPScomp(CPSgen : CPSGEN) : CPSCOMP = 
struct

  structure MachSpec = CPSgen.MachSpec
  structure Convert = Convert(MachSpec)
  structure CPStrans = CPStrans(MachSpec)
  structure CPSopt = CPSopt(MachSpec)
  structure Closure = Closure(MachSpec)
  structure NewClosure = NClosure(MachSpec)
  structure Spill = Spill(MachSpec)

  val phase = Stats.doPhase o Stats.makePhase

  val convert   = phase "Compiler 060 Convert" Convert.convert
  val cpstrans  = phase "Compiler 065 CPStrans" CPStrans.cpstrans
  val cpsopt    = phase "Compiler 070 cpsopt" CPSopt.reduce
  val closure   = phase "Compiler 080 closure" 
                   (if MachSpec.newClosure then NewClosure.closeCPS
			                   else Closure.closeCPS)
  val globalfix = phase "Compiler 090 globalfix" GlobalFix.globalfix
  val spill    = if MachSpec.spillAreaSz < 500 * MachSpec.valueSize
		     then phase "Compiler 100 spill" Spill.spill
		     else fn x => x
  val limit     = phase "Compiler 110 limit" Limit.nolimit
  val codegen   = phase "Compiler 120 cpsgen" CPSgen.codegen

  fun compile(lambda,argument,err) = let           
      val (function,table) = convert lambda
      val function = cpstrans function
      val (function,table) = 
	     if !Control.CG.cpsopt then cpsopt(function,table,argument,false) 
	     else (function,table)
      val function = closure (function)
      val carg = globalfix (function)
      val carg = spill carg 
      val (carg,limits) = limit carg
      val _ = codegen(carg,limits,err)
    in  
      ()
    end (* compile *)

end (* CPScomp *)

functor CPScodeGenerator(structure Gen: CPSGEN
			 val collect: unit -> string) : CODEGENERATOR =
struct
  val architecture = Gen.MachSpec.architecture

  structure CPScomp = CPScomp(Gen)

  fun codegen({error,anyErrors,errorMatch},lambda)=
      CPScomp.compile(lambda,NONE,
		      fn severity => fn s => 
		      error (0,0) severity
			      (concat["Real constant out of range: ",s,"\n"]))

  val collect = collect
end

