(* Copyright 1992 by AT&T Bell Laboratories *)

signature COMPUTIL =
sig

  val debugmsg : string -> bool

  val isolate : ('a -> 'b) -> 'a -> 'b

end


structure CompUtil : COMPUTIL =
struct

  open Access Modules Absyn

  (* conditional message functions *)
  fun printmsg (flag: bool ref) (msg: string) : bool =
      if !flag
      then (app Control.Print.say[msg, "\n"]; Control.Print.flush(); true)
      else false

  val debugmsg = printmsg Control.debugging	

  exception Top_level_callcc

  local val cont_stack = ref (nil : unit ref list)

  in fun isolate f x = (* Just like f x, except that it catches
		       top-level callcc's  *)
   let val r = ref()
       val _ = cont_stack := r :: !cont_stack;
       fun pop_stack() =
	   case !cont_stack
	    of r' :: rest => (cont_stack := rest;
			      if r<>r' then raise Top_level_callcc else ())
	     | _ => raise Top_level_callcc (* can this ever happen? *)
       val a = f x 
	       handle e => (pop_stack(); raise e)
    in pop_stack (); 
       a
   end
  end


end (* structure CompUtil *)
