(* Copyright 1989,1991,1992 by AT&T Bell Laboratories *)

(*  *
 * Modified to support separate compilation with free
 * structure references. Also, code supporting import
 * command has been isolated for easy removal. (erg)
 *
 * "import" code has been removed, old ModuleComp code has been
 * incorporated, and name of functor has been changed to CompileUnit
 * from Importer.  Changed to use first-class environments and
 * to provide a minimal compilation interface to support separate
 * compilation.
 *)

signature COMPILE = sig

    exception Compile of string
    type lvar
    type absyn
    type lambda = Lambda.lexp		(* normal lambda *)
    type clambda			(* canonical lambda *)
    type plambda			(* pickled lambda *)
    type pid = PersStamps.persstamp
    type obj = System.Unsafe.object
    type lsegments = { l0: lambda, ln: lambda list }
    type csegments = { c0: string, cn: string list }

    val pickle: clambda -> plambda
    val unpickle: plambda -> clambda

    val parse: Source.inputSource -> Ast.dec

    val parseOne: Source.inputSource -> unit -> Ast.dec option

    val elaborate: {errors: ErrorMsg.errors,
		    corenv: StaticEnv.staticEnv,
		    compenv: StaticEnv.staticEnv,
		    transform: Absyn.dec -> Absyn.dec,  (* TEMPORARY *)
		    ast: Ast.dec}
	-> {absyn: Absyn.dec, 
	    newenv: StaticEnv.staticEnv,
	    exportLexp: lambda,
	    exportPid: pid option,
	    staticPid : pid}

    val makePid: StaticEnv.staticEnv -> pid

    val instrument: {source: Source.inputSource,
		     corenv: StaticEnv.staticEnv,
		     compenv: StaticEnv.staticEnv}
	-> Absyn.dec -> Absyn.dec

    val translate: { errors: ErrorMsg.errors,
		    corenv: StaticEnv.staticEnv,
		    absyn: Absyn.dec,
		    exportLexp: lambda,
		    statenv: StaticEnv.staticEnv,
		    exportPid: pid option }
	-> {
	    (* constructs code when supplied with inline code for imports *)
	    genLambda: lambda option list -> lambda,
	    (* the import pids *)
	    imports: pid list
	   }

    val symDelta: pid option * clambda option -> SymbolicEnv.symenv

    val architecture : string

    (* perform the inlining *)
    val inline: { genLambda: lambda option list -> lambda,
		  imports: pid list,
		  symenv: SymbolicEnv.symenv }
      -> lambda

    (* split code in expansive code segments
     * and an (optional) inlinable part *)
    val split:
	{ lambda: lambda, enable: bool }
	->
	{ lambda_e: lsegments, lambda_i: clambda option, pid: pid }

    val codegen: { errors: ErrorMsg.errors, lambda: lsegments }
	-> csegments 

    val applyCode : csegments -> obj vector -> obj

    (* the functions above raise ONLY the exception Compile;
     execute can raise other exceptions *)

    val execute: {executable: obj vector -> obj,
		  imports: pid list,
		  exportPid: pid option,
		  dynenv: DynamicEnv.dynenv}
	-> DynamicEnv.dynenv  (* new "delta" dynenv *)

end
