(* Copyright 1989 by AT&T Bell Laboratories *)
signature ABSTRACT_MACHINE = sig
  type EA
  val arithtemps : EA list
  val miscregs : EA list
  val floatregs : EA list
  val savedfpregs : EA list
end

signature CODEGENERATOR = sig
  val architecture : string
  val codegen : ErrorMsg.errors * Lambda.lexp -> unit
  val collect : unit -> string
end

signature CMACHINE_CODEGENERATOR = sig
  include CODEGENERATOR
  structure CMachine: CMACHINE
end

