(* io.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * An old-style IO interface built on top of the new IO stack.
 *)

structure IO =
struct
  type instream = TextIO.instream
  type outstream = TextIO.outstream
  exception Io = General.Io
  val std_in = TextIO.stdIn
  val std_out = TextIO.stdOut
  val std_err = TextIO.stdErr
  val open_in = TextIO.openIn
  val open_out = TextIO.openOut
  val open_append=TextIO.openAppend

 local structure T = TextIO
       structure S = T.StreamIO
       structure P = S.PrimIO
  in
  fun open_string src =
    let val closed = ref false
        val pos = ref 0
        fun ensureOpen() = if !closed then raise ClosedStream else ()
        fun readv n = let val p = !pos
                          val m = Int.min(String.size src - p,n)
		       in ensureOpen(); pos := p+m; String.substring(src,p,m)
                      end
     val r = P.Rd{readBlock=SOME readv,
	     readNoBlock=NONE,
	     readaBlock=NONE,
	     readaNoBlock=NONE,
	     block=SOME(fn()=>()),
	     canInput=SOME(fn()=>true),
	     name="<string>",
	     chunkSize=String.size src,
	     close=(fn()=>(ensureOpen(); closed:=true)),
	     getPos=fn() =>Position.fromInt(!pos),
	     setPos=fn p => pos := Position.toInt p,
             findPos=fn({data,first,nelems},p) => 
	                Position.+(p, Position.fromInt nelems),
             endPos=fn()=> Position.fromInt(String.size src),
	     desc=NONE}
     in T.mkInstream(S.mkInstream r)	     
    end
  end
  
  val close_in = TextIO.closeIn
  val close_out=TextIO.closeOut
  val output = TextIO.output
  fun outputc f x = output(f,x)
  val input = TextIO.inputN

  fun inputc f n = 
    let val g = TextIO.getInstream f
        val (s,g') = TextIO.StreamIO.input g
     in if size s > n
        then TextIO.inputN(f,n)
        else (TextIO.setInstream(f,g'); s)
    end

  val input_line = TextIO.inputLine
  fun lookahead f = #1(TextIO.StreamIO.inputN(TextIO.getInstream f, 1))
  val end_of_stream = TextIO.endOfStream
  fun can_input f = case TextIO.StreamIO.inputNoBlock(TextIO.getInstream f)
		      of SOME(x,_) => String.size x
		       | NONE => 0
  val flush_out = TextIO.flushOut
  fun is_term_in f = case TextIO.StreamIO.getReader(TextIO.getInstream f)
                      of TextIO.StreamIO.PrimIO.Rd{name="<stdIn>",...} => true
                       | _ => false
  fun is_term_out f = case TextIO.StreamIO.getWriter(TextIO.getOutstream f)
                      of TextIO.StreamIO.PrimIO.Wr{name="<stdIn>",...} => true
                       | _ => false

  fun set_term_in _ = ()
  fun set_term_out _ = ()
  

(** the following are too UNIX specific, so we cannot support them here **
  local 
      val exec : (string * string list * string list) -> (int*int) =
	  CInterface.c_function "SMLNJ-Process" "exec"
    structure P = PosixPrimIO
    val toFPI = Position.fromInt  (* temporary *)
    val toWord = SysWord.intToWord  (* temporary *)

(* a temporary hack *)
    val environ : unit -> string list
	  = CInterface.c_function "POSIX-ProcEnv" "environ"

 in
(* execute the specified command (with our environment) *)
  fun execute_in_env (cmd, args, env) = let
	fun basename s = let
	      val len = String.size s
	      fun f i = if i=len
		      then s
		    else if (String.sub(s, i) = #"/")
		      then g (i+1, i+1)
		      else f (i+1)
	      and g (base, i) = if i=len
		      then substring(s, base, len-base)
		    else if (String.sub(s, i) = #"/")
		      then g (i+1, i+1)
		      else g (base, i+1)
	      in
		f 0
	      end
	val (fdin, fdout) = exec (cmd, (basename cmd) :: args, env)
	      handle e => raise Io{cause=e,function="execute",name=""}

	val r = TextIO.mkInstream(TextIO.StreamIO.mkInstream(
			  TextIO.translateIn(	     
		       P.mkReader{fd=Posix.FileSys.wordToFD(toWord fdin),
			   name= "<pipeIn>", 
			   initPos=toFPI 0,
			   initBlkMode=true})))
        val w = TextIO.mkOutstream(TextIO.StreamIO.mkOutstream(
			 TextIO.translateOut(
		      P.mkWriter{fd=Posix.FileSys.wordToFD(toWord fdout),
				 name="<pipeOut>",
				 initBlkMode=true,
				 appendMode=false,
				 chunkSize=2048,
				 lineBuf=NONE})))
				 
         in (r, w)
	end

  fun execute (cmd, args) = execute_in_env (cmd, args, environ())

  end (* local *)
**)

end
