(* float-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature FLOAT =
  sig
    include REAL
    structure Math : MATH
      sharing type real = Math.real

    val radix     : Int.int	   (* 2 for IEEE, Vax; 16 for IBM *)

    val precision : Int.int
	(* the number of digits (each 0..radix-1) in mantissa *)

    val logb         : real -> Int.int 
	(* takes log to the base "radix", rounding towards negative infinity;
	 * it is a fancy name for "extract exponent"
	 *)
    val scalb        : real * Int.int -> real
	(* scalb(x,n) = x*radix^n *)

    val nextAfter    : real * real -> real
	(* nextAfter(x, y) returns the next representable real after x in the
	 * direction of y.  If x = y, then it returns x.
	 *)

    val maxFinite    : real   (* maximum finite number *)
(*** these cause problems on the alpha
    val minPos       : real   (* minimum non-zero positive number *)
    val minNormalPos : real   (* minimum non-zero normalized number *)
***)

  end;
