(* dummy.sml
 *
 * Copyright 1989 by AT&T Bell Laboratories
 *
 * This is a dummy implementation of the structures provided by the run-time
 * system.
 *)

abstraction Assembly : ASSEMBLYBOXED =
  struct
    type object = unit
    datatype 'a option = NONE | SOME of 'a
    val unitfn = fn () => ()
    structure AA = struct
      val array = InLine.cast(unitfn)
      type c_function = unit
      val bind_cfun = InLine.cast(unitfn)
      val callc = InLine.cast(unitfn)
      type bytearray = string
      type realarray = string
      val create_b = InLine.cast(unitfn)
      val create_r = InLine.cast(unitfn)
      val create_s = InLine.cast(unitfn)
      val create_v = InLine.cast(unitfn)
      val floor = InLine.cast(unitfn)
      val logb = InLine.cast(unitfn)
      val scalb =  InLine.cast(unitfn)
      type spin_lock = unit
      val try_lock = InLine.cast(unitfn)
      val unlock = InLine.cast(unitfn)
    end
    structure A : RUNVECBOXED = AA
    exception Div
    exception Overflow
    exception SysErr of (string * int option)
    exception UnboundTable
    val array0 = InLine.cast()
    val bytearray0 = InLine.cast()
    val profCurrent = InLine.cast()
    val pollEvent = InLine.cast()
    val pollFreq  = InLine.cast()
    val pollHandler = InLine.cast()
    val activeProcs = InLine.cast()
    val pstruct = InLine.cast()
    val realarray0 = InLine.cast()
    val sighandler = InLine.cast()
    val vector0 = InLine.cast()
end

