(* cleanup-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * This provides a mechanism for registering actions that should be performed
 * at initialization or termination time.  We define five distinct contexts
 * for a hook:
 *
 *	AtExportML	just prior to exporting a heap image (exportML).
 *	AtExportFn	exit because of exportFn.
 *	AtExit		normal program exit.
 *	AtInit		initialization of a program that was generated by exportML.
 *	AtInitFn	initialization of a program that was generated by exportFn.
 *)

signature CLEAN_UP =
  sig

    datatype when = AtExportML | AtExportFn | AtExit | AtInit | AtInitFn

    val atAll : when list
	(* at all times *)

    val addCleaner    : (string * when list * (when -> unit))
	  -> (when list * (when -> unit)) option
	(* add the named cleaner.  This returns the previous definition, or NONE. *)

    val removeCleaner : string -> (when list * (when -> unit)) option
	(* remove and return the named cleaner; return NONE if it is not found *)

  end (* CLEAN_UP *)

