(* bind-overloads.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * This file defines the infix definitions and overloadings in the
 * pervasive top-level environment.
 *)

infix 7  * / quot mod rem div
infix 6 ^ + -
infix 3 := o
infix 4 > < >= <= = <>
infixr 5 :: @
infix 0 before

overload makestring : 'a -> string 
  as Int.toString 
  and Word8.toString and Word31.toString and Word32.toString
  and Real.toString
  and Bool.toString

overload print : 'a -> unit 
  as Print.string
  and Print.int
  and Print.real
  and Print.bool

overload ~ :   ('a -> 'a)
  as Int.~
  and Real.~
overload + :   ('a * 'a -> 'a)
  as Int.+
  and Word8.+ and Word31.+ and Word32.+
  and Real.+
overload - :   ('a * 'a -> 'a)
  as Int.-
  and Word8.- and Word31.- and Word32.-
  and Real.-
overload * :   ('a * 'a -> 'a)
  as Int.*
  and Word8.* and Word31.* and Word32.*
  and Real.*
overload div : ('a * 'a -> 'a)
  as Int.div
  and Word8.div and Word31.div and Word32.div
overload mod : ('a * 'a -> 'a)
  as Int.mod
  and Word8.mod and Word31.mod and Word32.mod
overload < :   ('a * 'a -> bool)
  as Char.<
  and String.<
  and Int.<
  and Word8.< and Word31.< and Word32.<
  and Real.<
overload <= :   ('a * 'a -> bool)
  as Char.<=
  and String.<=
  and Int.<=
  and Word8.<= and Word31.<= and Word32.<=
  and Real.<=
overload > :   ('a * 'a -> bool)
  as Char.>
  and String.>
  and Int.>
  and Word8.> and Word31.> and Word32.>
  and Real.>
overload >= :   ('a * 'a -> bool)
  as Char.>=
  and String.>=
  and Int.>=
  and Word8.>= and Word31.>= and Word32.>=
  and Real.>=
overload abs : ('a -> 'a)
  as Int.abs and Real.abs

