(* bin-basis.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * This file binds the SML Standard Library signatures and structures in the
 * pervasive top-level envirnment.
 *)

signature GENERAL = GENERAL
signature BOOL = BOOL
signature CHAR = CHAR
signature STRING = STRING
signature SUBSTRING = SUBSTRING
signature STRING_CVT = STRING_CVT
signature WORD = WORD
signature BYTE = BYTE
signature PACK_WORD = PACK_WORD
signature REAL = REAL
signature MATH = MATH
signature FLOAT = FLOAT
signature LIST = LIST
signature LIST_PAIR = LIST_PAIR
signature VECTOR = VECTOR
signature ARRAY = ARRAY
signature MONO_VECTOR = MONO_VECTOR
signature MONO_ARRAY = MONO_ARRAY
signature TIME = TIME
signature TIMER = TIMER
signature DATE = DATE
signature OS = OS
signature OS_PATH = OS_PATH
signature OS_FILE_SYS = OS_FILE_SYS
signature OS_PROCESS = OS_PROCESS

signature PRIM_IO = PRIM_IO
signature STREAM_IO = STREAM_IO
signature IMPERATIVE_IO = IMPERATIVE_IO
signature TEXT_IO = TEXT_IO
signature BIN_IO = BIN_IO

structure General =
  struct
    open General
    open ExnName
  end

structure Bool = Bool
structure List = List
structure ListPair = ListPair
structure Vector = Vector
structure Array = Array
structure Char = Char
structure CharVector = CharVector
structure CharArray = CharArray
structure String = String
structure Substring = Substring
structure StringCvt = StringCvt
structure Int = Int
structure Int31 = Int31
structure Word = Word
structure Word8 = Word8
structure Word8Array = Word8Array
structure Word8Vector = Word8Vector
structure Byte = Byte
structure Pack16Big = Pack16Big
structure Pack16Little = Pack16Little
structure Pack32Big = Pack32Big
structure Pack32Little = Pack32Little
structure Word31 = Word31
structure Word32 = Word32
structure Real = Real
structure Math = Math
structure Float = Float
structure Float64 = Float64
structure LargestFloat = Float
structure Time = Time
structure Timer = Timer
structure Date = Date
structure Position = Position
structure TextIO = TextIO
structure BinIO = BinIO
structure OS = OS
structure LargestInt = LargestInt
structure LargestWord = LargestWord
structure SysWord = SysWord
structure Offset = Offset

functor ImperativeIO = ImperativeIO
functor StreamIO = StreamIO
functor PrimIO = PrimIO

(* the following are not quite basis modules, but they are close to the
 * defined interface.
 *)
(***
signature LARGE_INT = LARGE_INT
structure LargeInt = LargeInt
***)
