(* assembly.sig
 *
 * Copyright 1989 by AT&T Bell Laboratories
 *
 * The interface to the structures provied by the run-time system.  The
 * boxed versions are necessary, because the assembly code that implements
 * the functions in RUNVEC uses the old calling convention (w/o representation
 * analysis).
 *)

signature RUNVEC =
  sig
    val array : int * 'a -> 'a array
    type c_function
    val bind_cfun : (string * string) -> c_function
    val callc : (c_function * 'a) -> 'c
    eqtype bytearray
    eqtype realarray
    val create_b : int -> bytearray
    val create_r : int -> realarray
    val create_s : int -> string
    val create_v : int * 'a list -> 'a vector
    val floor : real -> int
    val logb : real -> int
    val scalb : real * int -> real
    type spin_lock
    val try_lock : spin_lock -> bool
    val unlock : spin_lock -> unit
  end (* RUNVEC *)

signature ASSEMBLY =
  sig
    type object
    datatype 'a option = NONE | SOME of 'a
    structure A : RUNVEC
    exception Div
    exception Overflow
    exception SysErr of (string * int option)
    exception UnboundTable
    val array0 : 'a array
    val bytearray0 : A.bytearray
    val profCurrent : int ref
    val pollEvent : bool ref
    val pollFreq : int ref
    val pollHandler : (unit cont -> unit cont) ref
    val activeProcs : int ref
    val pstruct : object ref
    val realarray0 : A.realarray
    val sighandler : ((int * int * unit cont) -> unit cont) ref
    val vector0 : 'a vector
end

signature RUNVECBOXED =
  sig
    val array : 'a -> 'b
    type c_function
    val bind_cfun : 'a -> 'b
    val callc : 'a -> 'b
    eqtype bytearray
    eqtype realarray
    val create_b : 'a -> bytearray
    val create_r : 'a -> realarray
    val create_s : 'a -> 'b
    (*eqtype 'a vector*)
    val create_v : 'a -> 'b
    val floor : 'a -> 'b
    val logb : 'a -> 'b
    val scalb : 'a -> 'b
    type spin_lock
    val try_lock : spin_lock -> 'a
    val unlock : spin_lock -> 'a
  end (* RUNVEC *)

signature ASSEMBLYBOXED =
  sig
    type object
    datatype 'a option = NONE | SOME of 'a
    structure A : RUNVECBOXED
    exception Div
    exception Overflow
    exception SysErr of (string * int option)
    exception UnboundTable
    val array0 : 'a array
    val bytearray0 : A.bytearray
    val profCurrent : int ref
    val pollEvent : bool ref
    val pollFreq : int ref
    val pollHandler : (unit cont -> unit cont) ref
    val activeProcs : int ref
    val pstruct : object ref
    val realarray0 : A.realarray
    val sighandler : ((int * int * unit cont) -> unit cont) ref
    val vector0 : 'a vector
end
